/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.Collections;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.BehaviorBase;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;

public class ClientBehaviorBase
extends BehaviorBase
implements ClientBehavior {
    private transient FacesContext _facesContext;

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        ClientBehaviorRenderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, component, this);
        }
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return Collections.emptySet();
    }

    public String getRendererType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScript(ClientBehaviorContext behaviorContext) {
        if (behaviorContext == null) {
            throw new NullPointerException("behaviorContext");
        }
        ClientBehaviorRenderer renderer = this.getRenderer(behaviorContext.getFacesContext());
        if (renderer != null) {
            try {
                this.setCachedFacesContext(behaviorContext.getFacesContext());
                String string = renderer.getScript(behaviorContext, this);
                return string;
            }
            finally {
                this.setCachedFacesContext(null);
            }
        }
        return null;
    }

    protected ClientBehaviorRenderer getRenderer(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            return context.getRenderKit().getClientBehaviorRenderer(rendererType);
        }
        return null;
    }

    FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    boolean isCachedFacesContext() {
        return this._facesContext != null;
    }

    void setCachedFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }
}

