/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.util.CacheHashMap;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.injectionengine.factory.OverrideReferenceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

class InjectionProcessorContext {
    public Map<Class<? extends Annotation>, Map<Class<?>, ObjectFactoryInfo>> ivObjectFactoryMap;
    public Map<Class<? extends Annotation>, Map<Class<?>, ObjectFactoryInfo>> ivNoOverrideObjectFactoryMap;
    public HashMap<Class<? extends Annotation>, OverrideReferenceFactory<?>[]> ivOverrideReferenceFactoryMap;
    public Map<String, InjectionBinding<?>> ivCompletedInjectionBindings;
    public boolean ivSaveNonCompInjectionBindings;
    public Map<Class<?>, Map<String, InjectionBinding<?>>> ivSavedGlobalInjectionBindings;
    public Map<Class<?>, Map<String, InjectionBinding<?>>> ivSavedAppInjectionBindings;
    public Map<Class<?>, Map<String, InjectionBinding<?>>> ivSavedModuleInjectionBindings;
    public boolean ivBindNonCompInjectionBindings;
    private Map<Class<?>, List<Method>> ivDeclaredSetMethodCache;
    public final List<InjectionBinding<?>> ivProcessedInjectionBindings = new ArrayList();
    public Context ivJavaNameSpaceContext;
    private Context ivJavaCompEnvNameSpaceContext;
    private final Context[] ivJavaNameSpaceContexts = new Context[InjectionScope.size()];

    protected InjectionProcessorContext() {
    }

    Map<Class<?>, List<Method>> getDeclaredSetMethodCache() {
        if (this.ivDeclaredSetMethodCache == null) {
            this.ivDeclaredSetMethodCache = new CacheHashMap(50);
        }
        return this.ivDeclaredSetMethodCache;
    }

    public Context getJavaNameSpaceContext(InjectionScope scope) throws NamingException {
        if (scope == null) {
            return this.getJavaCompEnvNameSpaceContext();
        }
        int index = scope.ordinal();
        Context result = this.ivJavaNameSpaceContexts[index];
        if (result == null) {
            this.ivJavaNameSpaceContexts[index] = result = (Context)this.ivJavaNameSpaceContext.lookup(scope.contextName());
        }
        return result;
    }

    public Context getJavaCompEnvNameSpaceContext() throws NamingException {
        if (this.ivJavaCompEnvNameSpaceContext == null) {
            this.ivJavaCompEnvNameSpaceContext = (Context)this.getJavaNameSpaceContext(InjectionScope.COMP).lookup("env");
        }
        return this.ivJavaCompEnvNameSpaceContext;
    }

    public void metadataProcessingComplete() {
        for (InjectionBinding<?> binding : this.ivProcessedInjectionBindings) {
            binding.metadataProcessingComplete();
        }
    }

    public String toString() {
        String nl = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n")) + "                                 ";
        StringBuilder sb = new StringBuilder();
        sb.append(nl).append("*** InjectionProcessorContext ***");
        sb.append(nl).append("Active bindings    = ").append(this.ivCompletedInjectionBindings != null);
        sb.append(nl).append("Save non-java:comp = ").append(this.ivSaveNonCompInjectionBindings);
        sb.append(nl).append("  java:global      = ").append(this.ivSavedGlobalInjectionBindings != null);
        sb.append(nl).append("  java:app         = ").append(this.ivSavedAppInjectionBindings != null);
        sb.append(nl).append("  java:module      = ").append(this.ivSavedModuleInjectionBindings != null);
        sb.append(nl).append("Bind non-java:comp = ").append(this.ivBindNonCompInjectionBindings);
        return sb.toString();
    }
}

