/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.common.structures.CacheEntry;
import com.ibm.ws.security.common.structures.CommonCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SingleTableCache
extends CommonCache {
    protected Map<String, Object> lookupTable;
    static final long serialVersionUID = -1025313071335404692L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SingleTableCache(long timeoutInMilliSeconds) {
        this(0, timeoutInMilliSeconds);
    }

    public SingleTableCache(int entryLimit, long timeoutInMilliSeconds) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        this.lookupTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        this.rescheduleCleanup(timeoutInMilliSeconds);
    }

    @Override
    public synchronized void remove(@Sensitive Object key) {
        this.lookupTable.remove(key);
    }

    @Override
    public synchronized Object get(@Sensitive String key) {
        CacheEntry entry = (CacheEntry)this.lookupTable.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired(this.timeoutInMilliSeconds)) {
            this.remove(key);
            return null;
        }
        return entry.getValue();
    }

    @Override
    public synchronized void put(@Sensitive String key, Object value) {
        CacheEntry entry = new CacheEntry(value);
        this.lookupTable.put(key, entry);
    }

    @Override
    protected synchronized void evictStaleEntries() {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.lookupTable.entrySet()) {
            String key = entry.getKey();
            Object cacheEntry = entry.getValue();
            if (cacheEntry != null && !((CacheEntry)cacheEntry).isExpired(this.timeoutInMilliSeconds)) continue;
            keysToRemove.add(key);
        }
        for (String keyToRemove : keysToRemove) {
            this.lookupTable.remove(keyToRemove);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.SingleTableCache", SingleTableCache.class, null, null);
    }
}

