/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import java.io.Closeable;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigProcessor
implements Closeable {
    private static final TraceComponent tc = Tr.register(ConfigProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String VALIDATION = "mp.openapi.extensions.liberty.validation";
    private static final boolean VALIDATION_DEFAULT_VALUE = true;
    private boolean validation = true;
    private static final String FILE_POLLING_INTERVAL = "mp.openapi.extensions.liberty.file.polling.interval";
    private static final int FILE_POLLING_INTERVAL_DEFAULT_VALUE = 2;
    private int pollingInterval = 2;
    private Config oaConfig;
    private OpenApiConfigImpl smallryeConfig;
    static final long serialVersionUID = -5480020246697436434L;

    public ConfigProcessor(ClassLoader appClassloader) {
        this.oaConfig = ConfigProvider.getConfig((ClassLoader)appClassloader);
        this.smallryeConfig = new OpenApiConfigImpl(this.oaConfig);
        this.validation = this.oaConfig.getOptionalValue(VALIDATION, Boolean.class).orElse(true);
        this.pollingInterval = this.oaConfig.getOptionalValue(FILE_POLLING_INTERVAL, Integer.class).filter(v -> v >= 0).orElse(2);
    }

    public OpenApiConfig getOpenAPIConfig() {
        return this.smallryeConfig;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public int getFilePollingInterval() {
        return this.pollingInterval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block3: {
            try {
                if (Closeable.class.isAssignableFrom(this.oaConfig.getClass())) {
                    ((Closeable)this.oaConfig).close();
                    this.oaConfig = null;
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.ConfigProcessor", (String)"87", (Object)this, (Object[])new Object[0]);
                if (!LoggingUtils.isEventEnabled(tc)) break block3;
                Tr.event((TraceComponent)tc, (String)("Failed to close config: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigProcessor : {\n");
        builder.append("mp.openapi.model.reader").append("=").append(this.smallryeConfig.modelReader()).append("\n");
        builder.append("mp.openapi.filter").append("=").append(this.smallryeConfig.filter()).append("\n");
        builder.append("mp.openapi.scan.disable").append("=").append(this.smallryeConfig.scanDisable()).append("\n");
        builder.append("mp.openapi.scan.packages").append("=").append(this.smallryeConfig.scanPackages()).append("\n");
        builder.append("mp.openapi.scan.classes").append("=").append(this.smallryeConfig.scanClasses()).append("\n");
        builder.append("mp.openapi.scan.exclude.packages").append("=").append(this.smallryeConfig.scanExcludePackages()).append("\n");
        builder.append("mp.openapi.scan.exclude.classes").append("=").append(this.smallryeConfig.scanExcludeClasses()).append("\n");
        builder.append("mp.openapi.servers").append("=").append(this.smallryeConfig.servers()).append("\n");
        builder.append("mp.openapi.extensions.scan-dependencies.disable").append("=").append(this.smallryeConfig.scanDependenciesDisable()).append("\n");
        builder.append("mp.openapi.extensions.scan-dependencies.jars").append("=").append(this.smallryeConfig.scanDependenciesJars()).append("\n");
        builder.append("mp.openapi.extensions.custom-schema-registry.class").append("=").append(this.smallryeConfig.customSchemaRegistryClass()).append("\n");
        builder.append("mp.openapi.extensions.application-path.disable").append("=").append(this.smallryeConfig.applicationPathDisable()).append("\n");
        builder.append(VALIDATION).append("=").append(this.validation).append("\n");
        builder.append(FILE_POLLING_INTERVAL).append("=").append(this.pollingInterval).append("\n");
        builder.append("}\n");
        return builder.toString();
    }
}

