/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.InternalConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.InvalidFrameworkStateException;
import io.openliberty.microprofile.config.internal.serverxml.OSGiConfigUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerXMLVariableConfigSource
extends InternalConfigSource
implements ConfigSource {
    private static final TraceComponent tc = Tr.register(ServerXMLVariableConfigSource.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
    private final GetServerXMLVariablesAction getServerXMLVariablesAction = new GetServerXMLVariablesAction();
    private BundleContext bundleContext;
    private ConfigVariables configVariables;
    static final long serialVersionUID = 7893806379847239513L;

    @Trivial
    public String getName() {
        return Tr.formatMessage((TraceComponent)tc, (String)"server.xml.variables.config.source", (Object[])new Object[0]);
    }

    @Trivial
    protected int getDefaultOrdinal() {
        return 500;
    }

    public Map<String, String> getProperties() {
        if (System.getSecurityManager() == null) {
            return this.getServerXMLVariables();
        }
        return AccessController.doPrivileged(this.getServerXMLVariablesAction);
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = OSGiConfigUtils.getBundleContext(((Object)((Object)this)).getClass());
        }
        return this.bundleContext;
    }

    @FFDCIgnore(value={InvalidFrameworkStateException.class})
    protected ConfigVariables getConfigVariables() {
        BundleContext bundleContext;
        if (this.configVariables == null && (bundleContext = this.getBundleContext()) != null) {
            try {
                this.configVariables = OSGiConfigUtils.getConfigVariables(bundleContext);
            }
            catch (InvalidFrameworkStateException invalidFrameworkStateException) {
                // empty catch block
            }
        }
        return this.configVariables;
    }

    protected Map<String, String> getServerXMLVariables() {
        ConfigVariables configVariables = this.getConfigVariables();
        Map<String, String> props = configVariables != null ? OSGiConfigUtils.getVariablesFromServerXML(configVariables) : Collections.emptyMap();
        return props;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetServerXMLVariablesAction
    implements PrivilegedAction<Map<String, String>> {
        static final long serialVersionUID = -8304759437285696854L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetServerXMLVariablesAction() {
        }

        @Override
        public Map<String, String> run() {
            return ServerXMLVariableConfigSource.this.getServerXMLVariables();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.ServerXMLVariableConfigSource$GetServerXMLVariablesAction", GetServerXMLVariablesAction.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
        }
    }
}

