/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTableClasses;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_Factory;
import com.ibm.ws.annocache.util.internal.UtilImpl_IdentityStringSet;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_NonInternSet;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsTableClassesImpl
implements TargetsTableClasses,
TargetCache_Readable {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected static final Logger stateLogger = AnnotationCacheServiceImpl_Logging.ANNO_STATE_LOGGER;
    public static final String CLASS_NAME = TargetsTableClassesImpl.class.getSimpleName();
    protected final String hashText;
    protected final UtilImpl_Factory utilFactory;
    protected final UtilImpl_InternMap classNameInternMap;
    protected final String classSourceName;
    protected final Map<String, String> i_packageNames;
    protected final Map<String, String> i_classNames;
    protected final Map<String, String> i_superclassNames;
    protected Map<String, String[]> i_interfaceNames;
    protected Map<String, Integer> i_modifiers;
    protected boolean didSetImplementers;
    protected final IdentityHashMap<String, Set<String>> i_allImplementers;
    protected boolean didSetDescendents;
    protected final IdentityHashMap<String, Set<String>> i_descendants;
    static final long serialVersionUID = -7911486464232101412L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetsTableClassesImpl(TargetsTableClassesImpl otherTable, UtilImpl_InternMap classNameInternMap, String classSourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "<init>", new Object[]{otherTable, classNameInternMap, classSourceName});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.utilFactory = otherTable.getUtilFactory();
        this.classNameInternMap = classNameInternMap;
        this.classSourceName = classSourceName;
        this.i_packageNames = this.internClassNamesMap(otherTable.i_packageNames);
        this.i_classNames = this.internClassNamesMap(otherTable.i_classNames);
        this.i_superclassNames = this.internClassNamesMap(otherTable.i_superclassNames);
        this.i_interfaceNames = this.internInterfaceNamesMap(otherTable.i_interfaceNames);
        this.i_modifiers = this.internModifiersMap(otherTable.i_modifiers);
        this.didSetDescendents = false;
        this.i_descendants = new IdentityHashMap();
        this.didSetImplementers = false;
        this.i_allImplementers = new IdentityHashMap();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, String[]> internInterfaceNamesMap(Map<String, String[]> i_otherInterfaceNamesMap) {
        IdentityHashMap<String, String[]> i_thisInterfaceNamesMap = new IdentityHashMap<String, String[]>();
        for (Map.Entry<String, String[]> i_otherEntry : i_otherInterfaceNamesMap.entrySet()) {
            String i_otherClassName = i_otherEntry.getKey();
            String[] i_otherInterfaceNames = i_otherEntry.getValue();
            String i_thisClassName = this.internClassName(i_otherClassName, true);
            String[] i_thisInterfaceNames = this.internInterfaceNames(i_otherInterfaceNames);
            i_thisInterfaceNamesMap.put(i_thisClassName, i_thisInterfaceNames);
        }
        return i_thisInterfaceNamesMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String[] internInterfaceNames(String[] i_otherInterfaceNames) {
        String[] i_thisInterfaceNames = new String[i_otherInterfaceNames.length];
        for (int interfaceNameNo = 0; interfaceNameNo < i_otherInterfaceNames.length; ++interfaceNameNo) {
            i_thisInterfaceNames[interfaceNameNo] = this.internClassName(i_otherInterfaceNames[interfaceNameNo], true);
        }
        return i_thisInterfaceNames;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, String> internClassNamesMap(Map<String, String> i_otherClassNamesMap) {
        IdentityHashMap<String, String> i_thisClassNamesMap = new IdentityHashMap<String, String>();
        for (Map.Entry<String, String> i_otherEntry : i_otherClassNamesMap.entrySet()) {
            String i_otherClassName = i_otherEntry.getKey();
            String i_otherMappedClassName = i_otherEntry.getValue();
            String i_thisClassName = this.internClassName(i_otherClassName, true);
            String i_thisMappedClassName = this.internClassName(i_otherMappedClassName, true);
            i_thisClassNamesMap.put(i_thisClassName, i_thisMappedClassName);
        }
        return i_thisClassNamesMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, Integer> internModifiersMap(Map<String, Integer> i_otherModifiersMap) {
        IdentityHashMap<String, Integer> i_thisModifiersMap = new IdentityHashMap<String, Integer>();
        for (Map.Entry<String, Integer> i_otherEntry : i_otherModifiersMap.entrySet()) {
            String i_otherClassName = i_otherEntry.getKey();
            Integer otherModifier = i_otherEntry.getValue();
            String i_thisClassName = this.internClassName(i_otherClassName, true);
            i_thisModifiersMap.put(i_thisClassName, otherModifier);
        }
        return i_thisModifiersMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetsTableClassesImpl(UtilImpl_Factory utilFactory, UtilImpl_InternMap classNameInternMap, String classSourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "<init>", new Object[]{utilFactory, classNameInternMap, classSourceName});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.utilFactory = utilFactory;
        this.classNameInternMap = classNameInternMap;
        this.classSourceName = classSourceName;
        this.i_packageNames = new IdentityHashMap<String, String>();
        this.i_classNames = new IdentityHashMap<String, String>();
        this.i_superclassNames = new IdentityHashMap<String, String>();
        this.i_interfaceNames = new IdentityHashMap<String, String[]>();
        this.i_modifiers = new IdentityHashMap<String, Integer>();
        this.didSetDescendents = false;
        this.i_descendants = new IdentityHashMap();
        this.didSetImplementers = false;
        this.i_allImplementers = new IdentityHashMap();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_Factory getUtilFactory() {
        return this.utilFactory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getClassNameInternMap() {
        return this.classNameInternMap;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className) {
        return this.classNameInternMap.intern(className);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className, boolean doForce) {
        return this.classNameInternMap.intern(className, doForce);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String lookupClassName(String className) {
        return this.classNameInternMap.intern(className, false);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> createIdentityStringSet() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "createIdentityStringSet", new Object[0]);
        }
        UtilImpl_IdentityStringSet utilImpl_IdentityStringSet = this.utilFactory.createIdentityStringSet();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_IdentityStringSet = utilImpl_IdentityStringSet;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "createIdentityStringSet", utilImpl_IdentityStringSet);
        }
        return utilImpl_IdentityStringSet;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> uninternClassNames(Set<String> use_i_classNames) {
        if (use_i_classNames == null) {
            return Collections.emptySet();
        }
        if (use_i_classNames.isEmpty()) {
            return Collections.emptySet();
        }
        return new UtilImpl_NonInternSet(this.getClassNameInternMap(), use_i_classNames);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassSourceName() {
        return this.classSourceName;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getPackageNamesMap() {
        return this.i_packageNames;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackageNames() {
        return this.uninternClassNames(this.i_packageNames.keySet());
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackageNames() {
        return this.i_packageNames.keySet();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsPackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsPackageName", new Object[]{packageName});
        }
        String i_packageName = this.internClassName(packageName, false);
        if (i_packageName == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsPackageName", bl);
            }
            return bl;
        }
        boolean bl = this.i_containsPackageName(i_packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsPackageName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_containsPackageName(String i_packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_containsPackageName", new Object[]{i_packageName});
        }
        boolean bl = this.i_packageNames.containsKey(i_packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_containsPackageName", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getClassNamesMap() {
        return this.i_classNames;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassNames() {
        return this.uninternClassNames(this.i_classNames.keySet());
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassNames() {
        return this.i_classNames.keySet();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsClassName", new Object[]{className});
        }
        String i_className = this.internClassName(className, false);
        if (i_className == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsClassName", bl);
            }
            return bl;
        }
        boolean bl = this.i_containsClassName(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "containsClassName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_containsClassName(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_containsClassName", new Object[]{i_className});
        }
        boolean bl = this.i_classNames.containsKey(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_containsClassName", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getSuperclassNamesMap() {
        return this.i_superclassNames;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSuperclassName(String subclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSuperclassName", new Object[]{subclassName});
        }
        String i_subclassName = this.internClassName(subclassName, false);
        if (i_subclassName == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSuperclassName", string);
            }
            return string;
        }
        String string = this.i_getSuperclassName(i_subclassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSuperclassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getSuperclassName(String i_subclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSuperclassName", new Object[]{i_subclassName});
        }
        String string = this.i_superclassNames.get(i_subclassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSuperclassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getSuperclassNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSuperclassNames", new Object[0]);
        }
        Map<String, String> map = this.i_superclassNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSuperclassNames", map);
        }
        return map;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String[]> i_getInterfaceNamesMap() {
        return this.i_interfaceNames;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String[] getInterfaceNames(String classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getInterfaceNames", new Object[]{classOrInterfaceName});
        }
        String i_classOrInterfaceName = this.internClassName(classOrInterfaceName, false);
        if (i_classOrInterfaceName == null) {
            String[] stringArray = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                stringArray = stringArray;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getInterfaceNames", stringArray);
            }
            return stringArray;
        }
        String[] stringArray = this.i_getInterfaceNames(i_classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getInterfaceNames", stringArray);
        }
        return stringArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String[] i_getInterfaceNames(String i_classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getInterfaceNames", new Object[]{i_classOrInterfaceName});
        }
        String[] stringArray = this.i_interfaceNames.get(i_classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getInterfaceNames", stringArray);
        }
        return stringArray;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String[]> i_getInterfaceNames() {
        return this.i_interfaceNames;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Integer> i_getModifiers() {
        return this.i_modifiers;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer getModifiers(String classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getModifiers", new Object[]{classOrInterfaceName});
        }
        String i_classOrInterfaceName = this.internClassName(classOrInterfaceName, false);
        if (i_classOrInterfaceName == null) {
            Integer n = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getModifiers", n);
            }
            return n;
        }
        Integer n = this.i_getModifiers(i_classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getModifiers", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getModifiersValue(String classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getModifiersValue", new Object[]{classOrInterfaceName});
        }
        Integer modifiers = this.getModifiers(classOrInterfaceName);
        int n = modifiers == null ? 0 : modifiers;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getModifiersValue", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer i_getModifiers(String i_classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getModifiers", new Object[]{i_classOrInterfaceName});
        }
        Integer n = this.i_modifiers.get(i_classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getModifiers", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int i_getModifiersValue(String i_classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getModifiersValue", new Object[]{i_classOrInterfaceName});
        }
        Integer modifiers = this.i_getModifiers(i_classOrInterfaceName);
        int n = modifiers == null ? 0 : modifiers;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getModifiersValue", n);
        }
        return n;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (stateLogger.isLoggable(Level.FINER)) {
            this.log(stateLogger);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Relationships: BEGIN [ {0} ]", this.getHashText());
        this.logClassNames(useLogger);
        this.logSuperclassNames(useLogger);
        this.logInterfaceNames(useLogger);
        this.logModifiers(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Relationships: END [ {0} ]", this.getHashText());
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logClassNames(Logger useLogger) {
        String methodName = "logClassNames";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Classes: BEGIN");
        for (String i_className : this.i_getClassNames()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ]", i_className);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Classes: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logSuperclassNames(Logger useLogger) {
        String methodName = "logSuperclsasNames";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Superclasses: BEGIN");
        Object[] logParms = new Object[]{null, null};
        Map<Object, Object> i_mapToIterate = this.i_superclassNames == null ? Collections.emptyMap() : this.i_superclassNames;
        for (Map.Entry<Object, Object> i_superclassNameEntry : i_mapToIterate.entrySet()) {
            String i_subclassName = (String)i_superclassNameEntry.getKey();
            String i_superclassName = (String)i_superclassNameEntry.getValue();
            logParms[0] = i_subclassName;
            logParms[1] = i_superclassName;
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Subclass [ {0} ] Superclass [ {1} ]", logParms);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Superclasses: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logInterfaceNames(Logger useLogger) {
        String methodName = "logInterfaceNames";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Interfaces: BEGIN");
        Object[] logParms = new Object[]{null, null};
        Map<Object, Object> i_mapToIterate = this.i_interfaceNames == null ? Collections.emptyMap() : this.i_interfaceNames;
        for (Map.Entry<Object, Object> i_interfaceNamesEntry : i_mapToIterate.entrySet()) {
            String i_childName = (String)i_interfaceNamesEntry.getKey();
            String[] use_i_interfaceNames = (String[])i_interfaceNamesEntry.getValue();
            logParms[0] = i_childName;
            logParms[1] = use_i_interfaceNames;
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Child [ {0} ] Interfaces [ {1} ]", logParms);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Interfaces: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logModifiers(Logger useLogger) {
        String methodName = "logModifiers";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Modifiers: BEGIN");
        Object[] logParms = new Object[]{null, null};
        Map<Object, Object> i_mapToIterate = this.i_modifiers == null ? Collections.emptyMap() : this.i_modifiers;
        for (Map.Entry<Object, Object> i_modifiersEntry : i_mapToIterate.entrySet()) {
            String i_childName = (String)i_modifiersEntry.getKey();
            Integer modifiers = (Integer)i_modifiersEntry.getValue();
            logParms[0] = i_childName;
            logParms[1] = modifiers;
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Child [ {0} ] Modifiers [ {1} ]", logParms);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Modifiers: END");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void record(String i_packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record", new Object[]{i_packageName});
        }
        this.i_packageNames.put(i_packageName, i_packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void record(String i_className, String i_superclassName, List<String> i_useInterfaceNames, int modifiers) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record", new Object[]{i_className, i_superclassName, i_useInterfaceNames, modifiers});
        }
        this.i_classNames.put(i_className, i_className);
        if (i_superclassName != null) {
            this.i_superclassNames.put(i_className, i_superclassName);
        }
        if (i_useInterfaceNames != null && !i_useInterfaceNames.isEmpty()) {
            this.i_interfaceNames.put(i_className, i_useInterfaceNames.toArray(new String[i_useInterfaceNames.size()]));
        }
        if (modifiers != 0) {
            this.i_modifiers.put(i_className, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean record(TargetsVisitorClassImpl.ClassData classData) {
        boolean didAdd;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record", new Object[]{classData});
        }
        String methodName = "record";
        String useClassSourceName = classData.classSourceName;
        boolean isClass = classData.isClass;
        if (!isClass) {
            String i_packageName = classData.i_className;
            boolean bl = didAdd = this.i_packageNames.put(i_packageName, i_packageName) == null;
            if (logger.isLoggable(Level.FINER)) {
                String useHashText = this.getHashText();
                String caseText = didAdd ? "added" : "ignored (duplicated)";
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] {2} Source [ {3} ]", new Object[]{useHashText, i_packageName, caseText, useClassSourceName});
            }
        } else {
            String i_className = classData.i_className;
            String i_superclassName = classData.i_superclassName;
            String[] i_useInterfaceNames = classData.i_interfaceNames;
            int modifiers = classData.modifiers;
            boolean bl = didAdd = this.i_classNames.put(i_className, i_className) == null;
            if (i_superclassName != null) {
                this.i_superclassNames.put(i_className, i_superclassName);
            }
            if (i_useInterfaceNames != null) {
                this.i_interfaceNames.put(i_className, i_useInterfaceNames);
            }
            if (modifiers != 0) {
                this.i_modifiers.put(i_className, modifiers);
            }
            if (logger.isLoggable(Level.FINER)) {
                String useHashText = this.getHashText();
                String caseText = didAdd ? "added" : "ignored (duplicated)";
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] {2} Source [ {3} ]", new Object[]{useHashText, i_className, caseText, useClassSourceName});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Superclass [ {2} ] {3}", new Object[]{useHashText, i_className, i_superclassName, caseText});
                if (i_useInterfaceNames != null) {
                    for (String i_interfaceName : i_useInterfaceNames) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Interface [ {2} ] {3} Source [ {4} ]", new Object[]{useHashText, i_className, i_interfaceName, caseText, useClassSourceName});
                    }
                }
            }
        }
        boolean bl = didAdd;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "record", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getAllImplementorsOf(String i_interfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getAllImplementorsOf", new Object[]{i_interfaceName});
        }
        this.forceAllImplementers();
        Set<String> result = this.i_allImplementers.get(i_interfaceName);
        if (result == null) {
            result = Collections.emptySet();
        }
        Set<String> set = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getAllImplementorsOf", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void forceAllImplementers() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceAllImplementers", new Object[0]);
        }
        if (this.didSetImplementers) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceAllImplementers");
            }
            return;
        }
        this.didSetImplementers = true;
        Iterator<String> iterator = this.i_classNames.keySet().iterator();
        while (iterator.hasNext()) {
            String i_implementerName;
            String i_nextImplementsSource = i_implementerName = iterator.next();
            while (i_nextImplementsSource != null) {
                String[] i_immediateImplements = this.i_interfaceNames.get(i_nextImplementsSource);
                if (i_immediateImplements != null) {
                    for (String i_immediateImplement : i_immediateImplements) {
                        Set<String> implementers = this.i_allImplementers.get(i_immediateImplement);
                        if (implementers == null) {
                            implementers = this.createIdentityStringSet();
                            this.i_allImplementers.put(i_immediateImplement, implementers);
                        }
                        implementers.add(i_implementerName);
                    }
                }
                i_nextImplementsSource = this.i_superclassNames.get(i_nextImplementsSource);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceAllImplementers");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getSubclassNames(String superclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSubclassNames", new Object[]{superclassName});
        }
        String i_superclassName = this.internClassName(superclassName, false);
        if (i_superclassName == null) {
            Set<String> set = Collections.emptySet();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSubclassNames", set);
            }
            return set;
        }
        Set<String> set = this.uninternClassNames(this.i_getSubclassNames(i_superclassName));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "getSubclassNames", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getSubclassNames(String i_superclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSubclassNames", new Object[]{i_superclassName});
        }
        this.forceDescendantsMap();
        Set<String> result = this.i_descendants.get(i_superclassName);
        if (result == null) {
            result = Collections.emptySet();
        }
        Set<String> set = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_getSubclassNames", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void forceDescendantsMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceDescendantsMap", new Object[0]);
        }
        if (this.didSetDescendents) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceDescendantsMap");
            }
            return;
        }
        this.didSetDescendents = true;
        Iterator<String> iterator = this.i_superclassNames.keySet().iterator();
        while (iterator.hasNext()) {
            String i_subclassName;
            String i_superclassName = i_subclassName = iterator.next();
            while ((i_superclassName = this.i_superclassNames.get(i_superclassName)) != null) {
                Set<String> subclasses = this.i_descendants.get(i_superclassName);
                if (subclasses == null) {
                    subclasses = this.createIdentityStringSet();
                    this.i_descendants.put(i_superclassName, subclasses);
                }
                subclasses.add(i_subclassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "forceDescendantsMap");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_isInstanceOf(String i_candidateClassName, String i_targetName, boolean targetIsInterface) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_isInstanceOf", new Object[]{i_candidateClassName, i_targetName, targetIsInterface});
        }
        if (i_candidateClassName == i_targetName) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_isInstanceOf", bl);
            }
            return bl;
        }
        if (targetIsInterface) {
            while (i_candidateClassName != null) {
                String[] use_i_interfaceNames = this.i_getInterfaceNames(i_candidateClassName);
                if (use_i_interfaceNames != null) {
                    for (String use_i_interfaceName : use_i_interfaceNames) {
                        if (use_i_interfaceName != i_targetName) continue;
                        boolean bl = true;
                        if (logger != null && logger.isLoggable(Level.FINER)) {
                            bl = bl;
                            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_isInstanceOf", bl);
                        }
                        return bl;
                    }
                }
                i_candidateClassName = this.i_getSuperclassName(i_candidateClassName);
            }
        } else {
            while ((i_candidateClassName = this.i_getSuperclassName(i_candidateClassName)) != null) {
                if (i_candidateClassName != i_targetName) continue;
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_isInstanceOf", bl);
                }
                return bl;
            }
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "i_isInstanceOf", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "readUsing", new Object[]{reader});
        }
        List<TargetCache_ParseError> list = reader.read(this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "readUsing", list);
        }
        return list;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateClassNames(Set<String> i_allResolvedClassNames, Set<String> i_newlyResolvedClassNames, Set<String> i_allUnresolvedClassNames, Set<String> i_newlyUnresolvedClassNames) {
        String methodName = "updateClassNames";
        Object[] logParms = logger.isLoggable(Level.FINER) ? new Object[]{this.hashText, null} : null;
        if (logParms != null) {
            logParms[1] = Integer.toString(i_allResolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] All resolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_allUnresolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] All unresolved [ {1} ]", logParms);
        }
        for (String string : this.i_getPackageNames()) {
            if (!i_allResolvedClassNames.add(string)) {
                if (logParms == null) continue;
                logParms[1] = string;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Already resolved package [ {1} ]", logParms);
                continue;
            }
            i_allUnresolvedClassNames.remove(string);
            i_newlyResolvedClassNames.add(string);
            if (logParms == null) continue;
            logParms[1] = string;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resolved package [ {1} ]", logParms);
        }
        for (String string : this.i_getClassNames()) {
            if (!i_allResolvedClassNames.add(string)) {
                if (logParms == null) continue;
                logParms[1] = string;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Already resolved class [ {1} ]", logParms);
                continue;
            }
            i_allUnresolvedClassNames.remove(string);
            i_newlyResolvedClassNames.add(string);
            if (logParms == null) continue;
            logParms[1] = string;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resolved class [ {1} ]", logParms);
        }
        for (Map.Entry entry : this.i_superclassNames.entrySet()) {
            String i_subclassName = (String)entry.getKey();
            if (!i_newlyResolvedClassNames.contains(i_subclassName)) {
                if (logParms == null) continue;
                logParms[1] = i_subclassName;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resolved subclass [ {1} ]", logParms);
                continue;
            }
            String i_superclassName = (String)entry.getValue();
            if (i_allResolvedClassNames.contains(i_superclassName)) {
                if (logParms == null) continue;
                logParms[1] = i_superclassName;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resolved superclass [ {1} ]", logParms);
                continue;
            }
            i_allUnresolvedClassNames.add(i_superclassName);
            i_newlyUnresolvedClassNames.add(i_superclassName);
            if (logParms == null) continue;
            logParms[1] = i_superclassName;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Unresolved superclass [ {1} ]", logParms);
        }
        for (Map.Entry entry : this.i_getInterfaceNamesMap().entrySet()) {
            String[] use_i_interfaceNames;
            String i_implementerName = (String)entry.getKey();
            if (!i_newlyResolvedClassNames.contains(i_implementerName)) {
                if (logParms == null) continue;
                logParms[1] = i_implementerName;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Previously resolved implementer [ {1} ]", logParms);
                continue;
            }
            for (String i_interfaceName : use_i_interfaceNames = (String[])entry.getValue()) {
                if (i_allResolvedClassNames.contains(i_interfaceName)) {
                    if (logParms == null) continue;
                    logParms[1] = i_interfaceName;
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Previously resolved interface [ {1} ]", logParms);
                    continue;
                }
                i_allUnresolvedClassNames.add(i_interfaceName);
                i_newlyUnresolvedClassNames.add(i_interfaceName);
                if (logParms == null) continue;
                logParms[1] = i_interfaceName;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Unresolved interface [ {1} ]", logParms);
            }
        }
        if (logParms != null) {
            logParms[1] = Integer.toString(i_allResolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] All resolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_newlyResolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New resolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_allUnresolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] All unresolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_newlyUnresolvedClassNames.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New unresolved [ {1} ]", logParms);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean sameAs(TargetsTableClassesImpl otherTable, boolean isCongruent) {
        String sameAsReason;
        boolean sameAs;
        String methodName = "sameAs";
        if (otherTable == null) {
            sameAs = false;
            sameAsReason = "Null other table";
        } else if (otherTable == this) {
            sameAs = true;
            sameAsReason = "Same table";
        } else {
            sameAsReason = this.basicSameAs(otherTable, isCongruent);
            sameAs = sameAsReason == null;
            if (sameAs) {
                sameAsReason = "Same";
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] ({2})", new Object[]{this.hashText, sameAs, sameAsReason});
        }
        return sameAs;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String basicSameAs(TargetsTableClassesImpl otherTable, boolean isCongruent) {
        String i_otherClassName;
        String i_className;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", new Object[]{otherTable, isCongruent});
        }
        boolean doLog = logger.isLoggable(Level.FINER);
        Map<String, String> i_useClassNames = this.i_classNames;
        Map<String, String> i_otherClassNames = otherTable.i_classNames;
        if (i_useClassNames.size() != i_otherClassNames.size()) {
            if (!doLog) {
                String string = "different class count";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
                }
                return string;
            }
            String string = "Classes [ " + i_useClassNames.size() + " ] other [ " + i_otherClassNames.size() + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
            }
            return string;
        }
        Map<String, String> i_useSuperclassNames = this.i_superclassNames;
        Map<String, String> i_otherSuperclassNames = otherTable.i_superclassNames;
        if (i_useSuperclassNames.size() != i_otherSuperclassNames.size()) {
            if (!doLog) {
                String string = "different super class count";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
                }
                return string;
            }
            String string = "Super classes [ " + i_useSuperclassNames.size() + " ] other [ " + i_otherSuperclassNames.size() + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
            }
            return string;
        }
        Map<String, String[]> i_useInterfaceNames = this.i_interfaceNames;
        Map<String, String[]> i_otherInterfaceNames = otherTable.i_interfaceNames;
        if (i_useInterfaceNames.size() != i_otherInterfaceNames.size()) {
            if (!doLog) {
                String string = "different interface count";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
                }
                return string;
            }
            String string = "Interfaces [ " + i_useInterfaceNames.size() + " ] other [ " + i_otherInterfaceNames.size() + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
            }
            return string;
        }
        Map<String, Integer> i_useModifiers = this.i_modifiers;
        Map<String, Integer> i_otherModifiers = otherTable.i_modifiers;
        if (i_useModifiers.size() != i_otherModifiers.size()) {
            if (!doLog) {
                String string = "different modifiers count";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
                }
                return string;
            }
            String string = "Modifiers [ " + i_useModifiers.size() + " ] other [ " + i_otherModifiers.size() + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
            }
            return string;
        }
        for (String string : i_useClassNames.keySet()) {
            String i_otherClassName2;
            String string2 = i_otherClassName2 = isCongruent ? string : otherTable.lookupClassName(string);
            if (i_otherClassName2 == null) {
                if (!doLog) {
                    String string3 = "different class names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string3 = string3;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string3);
                    }
                    return string3;
                }
                String string4 = "Other does not store [ " + string + " ] from classes table";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string4 = string4;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string4);
                }
                return string4;
            }
            if (i_otherClassNames.containsKey(i_otherClassName2)) continue;
            if (!doLog) {
                String string5 = "different class names";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string5 = string5;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string5);
                }
                return string5;
            }
            String string6 = "Other does not store class [ " + string + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string6 = string6;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string6);
            }
            return string6;
        }
        for (Map.Entry entry : i_useSuperclassNames.entrySet()) {
            i_className = (String)entry.getKey();
            String string = i_otherClassName = isCongruent ? i_className : otherTable.lookupClassName(i_className);
            if (i_otherClassName == null) {
                if (!doLog) {
                    String string7 = "different superclass names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string7 = string7;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string7);
                    }
                    return string7;
                }
                String string8 = "Other does not store [ " + i_className + " ] from superclasses table";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string8 = string8;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string8);
                }
                return string8;
            }
            String i_otherSuperclassName = i_otherSuperclassNames.get(i_otherClassName);
            if (i_otherSuperclassName == null) {
                if (!doLog) {
                    String string9 = "different superclass names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string9 = string9;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string9);
                    }
                    return string9;
                }
                String string10 = "Other does not store superclass of [ " + i_className + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string10 = string10;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string10);
                }
                return string10;
            }
            String i_superclassName = (String)entry.getValue();
            if ((!isCongruent || i_superclassName == i_otherSuperclassName) && (isCongruent || i_superclassName.equals(i_otherSuperclassName))) continue;
            if (!doLog) {
                String string11 = "different superclass names";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string11 = string11;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string11);
                }
                return string11;
            }
            String string12 = "Changed superclass of [ " + i_className + " ] from [ " + i_superclassName + " ] to [ " + i_otherSuperclassName + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string12 = string12;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string12);
            }
            return string12;
        }
        for (Map.Entry entry : i_useInterfaceNames.entrySet()) {
            i_className = (String)entry.getKey();
            String string = i_otherClassName = isCongruent ? i_className : otherTable.lookupClassName(i_className);
            if (i_otherClassName == null) {
                if (!doLog) {
                    String string13 = "different interface names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string13 = string13;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string13);
                    }
                    return string13;
                }
                String string14 = "Other does not store of [ " + i_className + " ] from interfaces table";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string14 = string14;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string14);
                }
                return string14;
            }
            String[] i_otherNames = i_otherInterfaceNames.get(i_otherClassName);
            if (i_otherNames == null) {
                if (!doLog) {
                    String string15 = "different interface names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string15 = string15;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string15);
                    }
                    return string15;
                }
                String string16 = "Other does not store interfaces of [ " + i_className + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string16 = string16;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string16);
                }
                return string16;
            }
            String[] i_names = (String[])entry.getValue();
            if (i_names.length != i_otherNames.length) {
                if (!doLog) {
                    String string17 = "different interface names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string17 = string17;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string17);
                    }
                    return string17;
                }
                String string18 = "Changed interface count of [ " + i_className + " ] from [ " + i_names.length + " ] to [ " + i_otherNames.length + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string18 = string18;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string18);
                }
                return string18;
            }
            for (int offset = 0; offset < i_names.length; ++offset) {
                String i_interface = i_names[offset];
                String i_otherInterface = i_otherNames[offset];
                if ((!isCongruent || i_interface == i_otherInterface) && (isCongruent || i_interface.equals(i_otherInterface))) continue;
                if (!doLog) {
                    String string19 = "different interface names";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string19 = string19;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string19);
                    }
                    return string19;
                }
                String string20 = "Changed interface of [ " + i_className + " ] [ " + offset + " ] from [ " + i_interface + " ] to [ " + i_otherInterface + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string20 = string20;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string20);
                }
                return string20;
            }
        }
        for (Map.Entry entry : i_useModifiers.entrySet()) {
            i_className = (String)entry.getKey();
            String string = i_otherClassName = isCongruent ? i_className : otherTable.lookupClassName(i_className);
            if (i_otherClassName == null) {
                if (!doLog) {
                    String string21 = "different modifiers";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string21 = string21;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string21);
                    }
                    return string21;
                }
                String string22 = "Other does not store class [ " + i_className + " ] from modifiers table";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string22 = string22;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string22);
                }
                return string22;
            }
            Integer otherModifier = i_otherModifiers.get(i_otherClassName);
            if (otherModifier == null) {
                if (!doLog) {
                    String string23 = "different modifiers";
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string23 = string23;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string23);
                    }
                    return string23;
                }
                String string24 = "Other does not store modifiers of [ " + i_className + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string24 = string24;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string24);
                }
                return string24;
            }
            Integer modifier = (Integer)entry.getValue();
            if (modifier.intValue() == otherModifier.intValue()) continue;
            if (!doLog) {
                String string25 = "different modifier";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string25 = string25;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string25);
                }
                return string25;
            }
            String string26 = "Changed modifier of [ " + i_className + " ] from [ " + modifier + " ] to [ " + otherModifier + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string26 = string26;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string26);
            }
            return string26;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "basicSameAs", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String printString(Set<String> values) {
        if (values.isEmpty()) {
            return "{ }";
        }
        if (values.size() == 1) {
            Iterator<String> iterator = values.iterator();
            if (iterator.hasNext()) {
                String value = iterator.next();
                return "{ " + value + " }";
            }
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean first = true;
        for (String value : values) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(value);
        }
        builder.append(" }");
        return builder.toString();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void restrictedAdd(TargetsTableClassesImpl otherClassTable, Set<String> i_newlyAddedPackageNames, Set<String> i_allAddedPackageNames, Set<String> i_newlyAddedClassNames, Set<String> i_allAddedClassNames) {
        String methodName = "restrictedAdd";
        this.i_addPackageNames(otherClassTable.i_getPackageNames(), i_newlyAddedPackageNames, i_allAddedPackageNames);
        this.i_addClassNames(otherClassTable.i_getClassNames(), i_newlyAddedClassNames, i_allAddedClassNames);
        this.i_addSuperclassNames(otherClassTable.i_getSuperclassNames(), i_newlyAddedClassNames);
        this.i_addInterfaceNames(otherClassTable.i_getInterfaceNames(), i_newlyAddedClassNames);
        this.i_addModifiers(otherClassTable.i_getModifiers(), i_newlyAddedClassNames);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New Packages [ {1} ]", new Object[]{this.hashText, this.printString(i_newlyAddedPackageNames)});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New Classes [ {1} ]", new Object[]{this.hashText, this.printString(i_newlyAddedClassNames)});
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addPackageNames(Set<String> i_otherPackageNames, Set<String> i_newlyAddedPackageNames, Set<String> i_allAddedPackageNames) {
        for (String i_packageName : i_otherPackageNames) {
            if (i_allAddedPackageNames.contains(i_packageName)) continue;
            this.i_packageNames.put(i_packageName, i_packageName);
            i_newlyAddedPackageNames.add(i_packageName);
            i_allAddedPackageNames.add(i_packageName);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addClassNames(Set<String> i_otherClassNames, Set<String> i_newlyAddedClassNames, Set<String> i_allAddedClassNames) {
        for (String i_className : i_otherClassNames) {
            if (i_allAddedClassNames.contains(i_className)) continue;
            this.i_classNames.put(i_className, i_className);
            i_newlyAddedClassNames.add(i_className);
            i_allAddedClassNames.add(i_className);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addSuperclassNames(Map<String, String> i_otherSuperclassNames, Set<String> i_newlyAddedClassNames) {
        for (Map.Entry<String, String> i_otherSuperclassNameEntry : i_otherSuperclassNames.entrySet()) {
            String i_otherClassName = i_otherSuperclassNameEntry.getKey();
            String i_otherSuperclassName = i_otherSuperclassNameEntry.getValue();
            if (!i_newlyAddedClassNames.contains(i_otherClassName)) continue;
            this.i_superclassNames.put(i_otherClassName, i_otherSuperclassName);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addInterfaceNames(Map<String, String[]> i_otherInterfaceNames, Set<String> i_newlyAddedClassNames) {
        for (Map.Entry<String, String[]> i_otherInterfaceNamesEntry : i_otherInterfaceNames.entrySet()) {
            String i_otherClassName = i_otherInterfaceNamesEntry.getKey();
            String[] i_useOtherInterfaceNames = i_otherInterfaceNamesEntry.getValue();
            if (!i_newlyAddedClassNames.contains(i_otherClassName)) continue;
            this.i_interfaceNames.put(i_otherClassName, i_useOtherInterfaceNames);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addModifiers(Map<String, Integer> i_otherModifiers, Set<String> i_newlyAddedClassNames) {
        for (Map.Entry<String, Integer> i_otherModifiersEntry : i_otherModifiers.entrySet()) {
            String i_otherClassName = i_otherModifiersEntry.getKey();
            Integer otherModifier = i_otherModifiersEntry.getValue();
            if (!i_newlyAddedClassNames.contains(i_otherClassName)) continue;
            this.i_modifiers.put(i_otherClassName, otherModifier);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean jandex_i_addPackage(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_addPackage", new Object[]{i_className});
        }
        boolean bl = this.i_packageNames.put(i_className, i_className) == null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_addPackage", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean jandex_i_addClass(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_addClass", new Object[]{i_className});
        }
        boolean bl = this.i_classNames.put(i_className, i_className) == null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_addClass", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void jandex_i_setSuperclassName(String i_className, String i_superclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setSuperclassName", new Object[]{i_className, i_superclassName});
        }
        this.i_superclassNames.put(i_className, i_superclassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setSuperclassName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void jandex_i_setInterfaceNames(String i_className, String[] i_useInterfaceNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setInterfaceNames", new Object[]{i_className, i_useInterfaceNames});
        }
        this.i_interfaceNames.put(i_className, i_useInterfaceNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setInterfaceNames");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void jandex_i_setModifiers(String i_className, int modifiers) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setModifiers", new Object[]{i_className, modifiers});
        }
        if (modifiers != 0) {
            this.i_modifiers.put(i_className, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl", "jandex_i_setModifiers");
        }
    }
}

