/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.MetricsJaxRsEMCallbackImpl;
import io.openliberty.microprofile.metrics.internal.monitor.MonitorCounter;
import io.openliberty.microprofile.metrics.internal.monitor.MonitorGauge;
import io.openliberty.microprofile.metrics.internal.monitor.MonitorSimpleTimer;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorMetrics {
    private static final TraceComponent tc = Tr.register(MonitorMetrics.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    protected String objectName;
    protected String mbeanStatsName;
    protected MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    protected Set<MetricID> vendorMetricIDs;
    protected Set<MetricID> baseMetricIDs;
    static final long serialVersionUID = -6206545054803192547L;

    public MonitorMetrics(String objectName) {
        this.objectName = objectName;
        this.vendorMetricIDs = new HashSet<MetricID>();
        this.baseMetricIDs = new HashSet<MetricID>();
    }

    public void createMetrics(SharedMetricRegistries sharedMetricRegistry, String[][] data) {
        MetricRegistry vendorRegistry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        MetricRegistry baseRegistry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.BASE.getName());
        MetricRegistry metricRegistry = null;
        Set<MetricID> metricIDSet = null;
        for (String[] metricData : data) {
            String metricName = metricData[1];
            String metricTagName = metricData[8];
            Tag metricTag = null;
            if (metricTagName != null) {
                metricTag = new Tag(metricTagName, this.getMBeanStatsString());
            }
            MetricID metricID = new MetricID(metricName, new Tag[]{metricTag});
            MetricType type = MetricType.valueOf((String)metricData[4]);
            metricRegistry = metricData[0].equalsIgnoreCase("vendor") ? vendorRegistry : baseRegistry;
            Set<MetricID> set = metricIDSet = metricData[0].equalsIgnoreCase("vendor") ? this.vendorMetricIDs : this.baseMetricIDs;
            if (MetricType.COUNTER.equals((Object)type)) {
                MonitorCounter mc = metricData[7] == null ? new MonitorCounter(this.mbs, this.objectName, metricData[6]) : new MonitorCounter(this.mbs, this.objectName, metricData[6], metricData[7]);
                metricRegistry.register(Metadata.builder().withName(metricName).withDisplayName(metricData[2]).withDescription(metricData[3]).withType(type).withUnit(metricData[5]).build(), (Metric)mc, new Tag[]{metricTag});
                metricIDSet.add(metricID);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Registered " + metricID.toString()), (Object[])new Object[0]);
                }
            } else if (MetricType.GAUGE.equals((Object)type)) {
                MonitorGauge mg = metricData[7] == null ? new MonitorGauge(this.mbs, this.objectName, metricData[6]) : new MonitorGauge(this.mbs, this.objectName, metricData[6], metricData[7]);
                metricRegistry.register(Metadata.builder().withName(metricName).withDisplayName(metricData[2]).withDescription(metricData[3]).withType(type).withUnit(metricData[5]).build(), mg, new Tag[]{metricTag});
                metricIDSet.add(metricID);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Registered " + metricID.toString()), (Object[])new Object[0]);
                }
            } else if (MetricType.SIMPLE_TIMER.equals((Object)type)) {
                MonitorSimpleTimer mst = new MonitorSimpleTimer(this.mbs, this.objectName, metricData[6], metricData[7], metricData[9], metricData[10]);
                String[] objName_rest = this.getRESTMBeanStatsTags();
                String appName = objName_rest[0];
                Tag classTag = new Tag("class", objName_rest[1]);
                Tag methodTag = new Tag("method", objName_rest[2]);
                metricRegistry.register(Metadata.builder().withName(metricName).withDisplayName(metricData[2]).withDescription(metricData[3]).withType(type).withUnit(metricData[5]).build(), (Metric)mst, new Tag[]{classTag, methodTag});
                metricID = new MetricID(metricName, new Tag[]{classTag, methodTag});
                metricIDSet.add(metricID);
                sharedMetricRegistry.associateMetricIDToApplication(metricID, appName, metricRegistry);
                MetricsJaxRsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(objName_rest[1], objName_rest[2]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Registered " + metricID.toString()), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to register " + metricName + " because of invalid type " + type), (Object[])new Object[0]);
            }
            metricRegistry = null;
        }
    }

    protected String[] getRESTMBeanStatsTags() {
        String[] mbeanNameProperty = new String[3];
        for (String subString : this.objectName.split(",")) {
            if (!(subString = subString.trim()).contains("name=")) continue;
            mbeanNameProperty = subString.split("/");
            mbeanNameProperty[0] = mbeanNameProperty[0].substring(mbeanNameProperty[0].indexOf("=") + 1, mbeanNameProperty[0].length());
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\(\\)", "");
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\(", "_");
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\)", "");
            break;
        }
        return mbeanNameProperty;
    }

    protected String getMBeanStatsString() {
        if (this.mbeanStatsName == null) {
            String serviceName = null;
            String serviceURL = null;
            String portName = null;
            String mbeanObjName = null;
            StringBuffer sb = new StringBuffer();
            for (String subString : this.objectName.split(",")) {
                if ((subString = subString.trim()).contains("service=")) {
                    serviceName = this.getMBeanStatsServiceName(subString);
                    serviceURL = this.getMBeanStatsServiceURL(subString);
                    continue;
                }
                if (subString.contains("port=")) {
                    portName = this.getMBeanStatsPortName(subString);
                    continue;
                }
                if (!subString.contains("name=")) continue;
                mbeanObjName = this.getMBeanStatsName(subString);
                break;
            }
            if (serviceURL != null && serviceName != null && portName != null) {
                sb.append(serviceURL);
                sb.append(".");
                sb.append(serviceName);
                sb.append(".");
                sb.append(portName);
            } else if (mbeanObjName != null) {
                sb.append(mbeanObjName);
            } else {
                sb.append("unknown");
            }
            this.mbeanStatsName = sb.toString();
        }
        return this.mbeanStatsName;
    }

    private String getMBeanStatsName(String nameStr) {
        String mbeanName = nameStr.split("=")[1];
        mbeanName = mbeanName.replaceAll(" ", "_");
        mbeanName = mbeanName.replaceAll("/", "_");
        mbeanName = mbeanName.replaceAll("[^a-zA-Z0-9_]", "_");
        return mbeanName;
    }

    private String getMBeanStatsServiceName(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceName = serviceStr.substring(serviceStr.indexOf("}") + 1);
        return serviceName;
    }

    private String getMBeanStatsServiceURL(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceURL = serviceStr.substring(serviceStr.indexOf("{") + 1, serviceStr.indexOf("}"));
        serviceURL = serviceURL.replace("http://", "").replace("https://", "").replace("/", ".");
        return serviceURL;
    }

    private String getMBeanStatsPortName(String portStr) {
        portStr = portStr.split("=")[1];
        String portName = portStr.replaceAll("\"", "");
        return portName;
    }

    public void unregisterMetrics(SharedMetricRegistries sharedMetricRegistry) {
        boolean rc;
        MetricRegistry vendorRegistry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        MetricRegistry baseRegistry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.BASE.getName());
        for (MetricID metricID : this.vendorMetricIDs) {
            rc = vendorRegistry.remove(metricID);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + metricID.toString() + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        for (MetricID metricID : this.baseMetricIDs) {
            rc = baseRegistry.remove(metricID);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + metricID.toString() + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        this.vendorMetricIDs.clear();
        this.baseMetricIDs.clear();
    }
}

