/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.FeatureAuthorizationTableService;
import com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.webcontainer.security.feature.authorizationConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class FeatureAuthorizationTable
extends AbstractSecurityAuthorizationTable
implements AuthorizationTableService,
UserRegistryChangeListener,
ConfigurationListener {
    private static final TraceComponent tc = Tr.register(FeatureAuthorizationTable.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.feature.resources.WebFeatureSecurityMessages");
    static final String CFG_KEY_ID = "id";
    static final String CFG_KEY_ROLE = "security-role";
    static final String KEY_FEATURE_SECURITY_COLLAB = "featureCollabAuthzTable";
    private final AtomicServiceReference<FeatureAuthorizationTableService> featureCollabAuthzTableRef = new AtomicServiceReference("featureCollabAuthzTable");
    protected String id = null;
    private String[] rolePids;
    static final long serialVersionUID = -4164829105316428955L;

    @Activate
    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        super.activate(cc);
        this.featureCollabAuthzTableRef.activate(cc);
        this.processConfigProps(props);
        if (this.id != null) {
            Tr.info((TraceComponent)tc, (String)"FEATURE_ROLE_CONFIG_PROCESSED", (Object[])new Object[]{this.id});
        }
    }

    @Modified
    protected synchronized void modified(Map<String, Object> props) {
        this.processConfigProps(props);
        if (this.id != null) {
            Tr.info((TraceComponent)tc, (String)"FEATURE_ROLE_CONFIG_PROCESSED", (Object[])new Object[]{this.id});
        }
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        FeatureAuthorizationTableService featureCollabAuthzTable = (FeatureAuthorizationTableService)this.featureCollabAuthzTableRef.getServiceWithException();
        featureCollabAuthzTable.removeAuthorizationTable(this.id);
        super.deactivate(cc);
        this.featureCollabAuthzTableRef.deactivate(cc);
    }

    @Reference(name="featureCollabAuthzTable", service=FeatureAuthorizationTableService.class)
    protected void setFeatureCollabAuthzTable(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureCollabAuthzTableRef.setReference(ref);
    }

    protected void unsetFeatureCollabAuthzTable(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureCollabAuthzTableRef.unsetReference(ref);
    }

    private void processConfigProps(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.id = (String)props.get(CFG_KEY_ID);
        if (this.id == null) {
            Tr.error((TraceComponent)tc, (String)"AUTHZ_ROLE_ID_IS_NULL", (Object[])new Object[0]);
            return;
        }
        this.rolePids = (String[])props.get(CFG_KEY_ROLE);
        this.processRolePids();
    }

    private synchronized void processRolePids() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processRolePids", (Object[])new Object[0]);
        }
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
        this.setFeatureRoleConfiguration(this.rolePids, configAdmin);
        FeatureAuthorizationTableService featureCollabAuthzTable = (FeatureAuthorizationTableService)this.featureCollabAuthzTableRef.getServiceWithException();
        featureCollabAuthzTable.addAuthorizationTable(this.id, (AuthorizationTableService)this);
    }

    public synchronized String getFeatureAuthorizationId() {
        return this.id;
    }

    protected synchronized String getApplicationName() {
        return this.id;
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigurationEvent:" + event.getType() + " pid=" + event.getPid() + " event:" + event), (Object[])new Object[0]);
        }
        if (event.getType() != 2 && this.pids.contains(event.getPid())) {
            this.processRolePids();
        }
    }
}

