/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.cdi23.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.cdi23.helper.Utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi23.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;

@ConcurrentGauge
@Interceptor
@Priority(value=1010)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrentGaugeInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    static final long serialVersionUID = 2526173068597110332L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    private ConcurrentGaugeInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object concurrentGaugeConstructor(InvocationContext context) throws Exception {
        return this.concurrentGaugeCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object concurrentGaugeMethod(InvocationContext context) throws Exception {
        return this.concurrentGaugeCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object concurrentGaugeTimeout(InvocationContext context) throws Exception {
        return this.concurrentGaugeCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object concurrentGaugeCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<ConcurrentGauge> concurrentGaugeAnno = this.resolver.concurentGauged(this.bean.getBeanClass(), element);
        MetricID tmid = new MetricID(concurrentGaugeAnno.metricName(), Utils.tagsToTags(concurrentGaugeAnno.tags()));
        org.eclipse.microprofile.metrics.ConcurrentGauge concurrentGauge = (org.eclipse.microprofile.metrics.ConcurrentGauge)this.registry.getMetrics().get(tmid);
        if (concurrentGauge == null) {
            throw new IllegalStateException("No concurrent gauge with metricID [" + tmid + "] found in registry [" + this.registry + "]");
        }
        concurrentGauge.inc();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            concurrentGauge.dec();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.cdi23.interceptors.ConcurrentGaugeInterceptor", ConcurrentGaugeInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }
}

