/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.security.AccessController;
import java.util.Dictionary;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RuntimeUpdateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class RuntimeUpdateListenerImpl
implements RuntimeUpdateListener {
    private static final TraceComponent tc = Tr.register(RuntimeUpdateListenerImpl.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
    volatile boolean configChecked = false;
    private ConfigurationAdmin configAdmin = null;
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    static final String EOL = System.lineSeparator();
    static final String sampleConfig = EOL + EOL + "    <httpSessionCache libraryRef=\"JCacheLib\"/>" + EOL + EOL + "   <library id=\"JCacheLib\">" + EOL + "        <file name=\"${shared.resource.dir}/jcache/JCacheProvider.jar\"/>" + EOL + "    </library>" + EOL;
    static final long serialVersionUID = 2161267059852782442L;

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configChecked = false;
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        configAdmin = null;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"notificationCreated", (Object[])new Object[]{notification.getName()});
        }
        if (this.configChecked) {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"notificationCreated: early return.", (Object)notification.getName());
            }
            return;
        }
        if (!this.configChecked && "ApplicationsStarting".equals(notification.getName())) {
            this.configChecked = true;
            try {
                String sessionCacheConfigFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)"com.ibm.ws.session.cache");
                Configuration[] sessionCacheConfigurations = this.configAdmin.listConfigurations(sessionCacheConfigFilter);
                if (sessionCacheConfigurations.length != 1 && trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("There should always be one exactly one sessionCacheConfiguration. Number of sessionCacheConfigurations found = " + sessionCacheConfigurations.length), (Object[])new Object[0]);
                }
                if (sessionCacheConfigurations != null) {
                    for (Configuration configuration : sessionCacheConfigurations) {
                        if (configuration == null) continue;
                        Dictionary props = configuration.getProperties();
                        String[] libraryRefs = (String[])props.get("libraryRef");
                        if (libraryRefs == null) {
                            if (this.isSessionCacheBellConfigured()) continue;
                            Tr.error((TraceComponent)tc, (String)"ERROR_CONFIG_INVALID_HTTPSESSIONCACHE", (Object[])new Object[]{Tr.formatMessage((TraceComponent)tc, (String)"SESSION_CACHE_CONFIG_MESSAGE", (Object[])new Object[]{sampleConfig})});
                            continue;
                        }
                        if (libraryRefs.length == 0) {
                            Tr.debug((TraceComponent)tc, (String)"The libraryRef attribute of the httpSessionCache in the server configuration could not be resolved. Check for possible CWWKG0033W messages.", (Object[])new Object[0]);
                            continue;
                        }
                        Configuration libraryConfiguration = this.configAdmin.getConfiguration(libraryRefs[0]);
                        if (libraryConfiguration != null) {
                            if (!trace || !tc.isDebugEnabled()) continue;
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"A httpSessionCache configuration with a valid libraryRef was found.", (Object[])new Object[0]);
                            continue;
                        }
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"A httpSessionCache configuration with a valid libraryRef was found, but the configuration the libraryRef points to is null. This should never happen.", (Object[])new Object[0]);
                    }
                }
            }
            catch (IOException | InvalidSyntaxException sessionCacheConfigFilter) {
                void ex;
                FFDCFilter.processException((Throwable)sessionCacheConfigFilter, (String)"com.ibm.ws.session.store.cache.RuntimeUpdateListenerImpl", (String)"134", (Object)this, (Object[])new Object[]{updateManager, notification});
                Tr.error((TraceComponent)tc, (String)"ERROR_SESSION_INIT", (Object[])new Object[]{ex});
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"notificationCreated", (Object)notification.getName());
        }
    }

    private boolean isSessionCacheBellConfigured() throws IOException, InvalidSyntaxException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean sessionCacheBellFound = false;
        String bellConfigFilter = FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.bell");
        Configuration[] bellConfigurations = this.configAdmin.listConfigurations(bellConfigFilter);
        if (bellConfigurations != null) {
            for (Configuration bellConfig : bellConfigurations) {
                String[] bellServices;
                if (bellConfig == null) continue;
                Dictionary bellProps = bellConfig.getProperties();
                for (String service : bellServices = (String[])bellProps.get("service")) {
                    if (!"javax.cache.spi.CachingProvider".equals(service)) continue;
                    sessionCacheBellFound = true;
                    String bellLibraryRef = (String)bellProps.get("libraryRef");
                    if (bellLibraryRef != null) {
                        Configuration libraryConfiguration = this.configAdmin.getConfiguration(bellLibraryRef);
                        if (libraryConfiguration != null) {
                            if (!trace || !tc.isDebugEnabled()) continue;
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"A javax.cache.spi.CachingProvider BELL with a valid libraryRef was found.", (Object[])new Object[0]);
                            continue;
                        }
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"A javax.cache.spi.CachingProvider BELL with a valid libraryRef was found, but the configuration the libraryRef points to is null. This should never happen.", (Object[])new Object[0]);
                        continue;
                    }
                    Tr.debug((TraceComponent)tc, (String)"A BELL with a javax.cache.spi.CachingProvider service was found, but the libraryRef is invalid. Check for possible CWWKG0033W messages.", (Object[])new Object[0]);
                }
            }
        }
        return sessionCacheBellFound;
    }
}

