/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.wsspi.webcontainer.async.WSAsyncEvent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AsyncListenerEntry {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.AsyncListenerEntry";
    private AsyncListener asyncListener;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean initialized = false;
    private AsyncContext asyncContext;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public AsyncListenerEntry(AsyncContext asyncContext, AsyncListener listener) {
        this.asyncContext = asyncContext;
        this.asyncListener = listener;
    }

    public AsyncListenerEntry(AsyncContext asyncContext, AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.asyncContext = asyncContext;
        this.asyncListener = listener;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.initialized = true;
    }

    public AsyncListener getAsyncListener() {
        return this.asyncListener;
    }

    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void invokeOnTimeout() {
        AsyncEvent asyncEvent = new AsyncEvent((javax.servlet.AsyncContext)this.asyncContext, this.servletRequest, this.servletResponse);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeOnTimeout", "listener->" + this.asyncListener);
            }
            this.asyncListener.onTimeout(asyncEvent);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "invokeOnTimeout", "an.io.related.error.has.occurred.during.the.processing.of.the.given.AsyncEvent");
        }
    }

    public void invokeOnComplete(long elapsedTime) {
        WSAsyncEvent asyncEvent = new WSAsyncEvent(this.asyncContext, this.servletRequest, this.servletResponse, elapsedTime);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeOnComplete", "listener->" + this.asyncListener);
            }
            this.asyncListener.onComplete((AsyncEvent)asyncEvent);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "invokeOnComplete", "an.io.related.error.has.occurred.during.the.processing.of.the.given.AsyncEvent");
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, CLASS_NAME, "invokeOnComplete", "uncaught.exception.during.AsyncListener.onComplete", new Object[]{this.getAsyncListener().getClass().getName(), e});
        }
    }

    public void invokeOnError(Throwable th) {
        AsyncEvent asyncEvent = new AsyncEvent((javax.servlet.AsyncContext)this.asyncContext, this.servletRequest, this.servletResponse, th);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeOnError", "listener->" + this.asyncListener);
            }
            this.asyncListener.onError(asyncEvent);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "invokeOnError", "an.io.related.error.has.occurred.during.the.processing.of.the.given.AsyncEvent");
        }
    }

    public void invokeOnStartAsync() {
        AsyncEvent asyncEvent = new AsyncEvent((javax.servlet.AsyncContext)this.asyncContext, this.servletRequest, this.servletResponse);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeOnStartAsync", "listener->" + this.asyncListener);
            }
            this.asyncListener.onStartAsync(asyncEvent);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "invokeOnStartAsync", "an.io.related.error.has.occurred.during.the.processing.of.the.given.AsyncEvent");
        }
    }
}

