/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.util.ZipFileResource;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;

public class MetaInfResourcesFileUtils {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils";
    private String searchRoot;
    private File[] libBinFiles;
    boolean recurseDirs;
    private ZipFileResource metaInfResFile;
    private File normalFile;

    public MetaInfResourcesFileUtils(String docRoot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "MetaInfResourcesFileUtils", "docRoot --> " + docRoot);
        }
        this.recurseDirs = true;
        this.searchRoot = docRoot + "/WEB-INF/lib";
        File rootDir = new File(this.searchRoot);
        this.libBinFiles = rootDir.listFiles();
    }

    public MetaInfResourcesFileUtils(ServletContext ctxt) {
        List<String> libBinPathList;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "MetaInfResourcesFileUtils", "ctxt --> " + ctxt);
        }
        if ((libBinPathList = ((IServletContext)ctxt).getWebAppConfig().getLibBinPathList()) == null || libBinPathList.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "MetaInfResourcesFileUtils", "libBinPathList is empty");
            }
            this.recurseDirs = true;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "MetaInfResourcesFileUtils", "libBinPathList is NOT empty");
            }
            this.recurseDirs = false;
            this.libBinFiles = new File[libBinPathList.size()];
            int i = 0;
            for (String libBinPath : libBinPathList) {
                this.libBinFiles[i] = new File(libBinPath);
                ++i;
            }
        }
    }

    public void findInMetaInfResource(String filename) {
        this.findInMetaInfResource(this.libBinFiles, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findInMetaInfResource(File[] searchPath, String filename) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "findInMetaInfResource", new Object[]{searchPath, filename});
        }
        this.normalFile = null;
        this.metaInfResFile = null;
        if (searchPath == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "findInMetaInfResource");
            }
            return;
        }
        for (int fc = 0; fc < searchPath.length; ++fc) {
            block33: {
                File curFile = searchPath[fc];
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "findInMetaInfResource", "searching->" + curFile);
                }
                if (curFile.isDirectory()) {
                    if (this.recurseDirs) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "findInMetaInfResource", "recursing to find more jar files");
                        }
                        File[] subDirSearchPath = curFile.listFiles();
                        this.findInMetaInfResource(subDirSearchPath, filename);
                    } else {
                        try {
                            String fullPath = curFile.getCanonicalPath() + "/META-INF/resources" + filename;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "findInMetaInfResource", "look for file[{0}] in loose config", new Object[]{fullPath});
                            }
                            this.normalFile = new File(fullPath);
                            if (!this.normalFile.exists()) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "findInMetaInfResource", "file does not exist");
                                }
                                this.normalFile = null;
                            }
                        }
                        catch (IOException e) {
                            Object[] args = new Object[]{e};
                            logger.logp(Level.SEVERE, CLASS_NAME, "findInMetaInfResource", "Engine.Exception.[{0}]", args);
                        }
                    }
                } else {
                    String curFileName = curFile.getName();
                    if (curFileName.toLowerCase().endsWith(".jar")) {
                        JarFile jarFile = null;
                        try {
                            jarFile = new JarFile(curFile);
                            String metaInfRelPath = "META-INF/resources" + filename;
                            ZipEntry zipEntry = jarFile.getEntry(metaInfRelPath);
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "findInMetaInfResource", "curFileName-->" + curFileName + ", zipEntry --> " + zipEntry);
                            }
                            if (zipEntry == null) break block33;
                            String fullURL = "jar:" + curFile.toURI().toURL().toString() + "!/" + metaInfRelPath;
                            URL url = null;
                            try {
                                url = new URL(fullURL);
                            }
                            catch (MalformedURLException e) {
                                Object[] args = new Object[]{e};
                                logger.logp(Level.SEVERE, CLASS_NAME, "findInMetaInfResource", "Engine.Exception.[{0}]", args);
                            }
                            if (url != null) {
                                this.metaInfResFile = new ZipFileResource(curFile, metaInfRelPath, url);
                            }
                        }
                        catch (IOException e) {
                            this.logException("findInMetaInfResource", filename, jarFile, e);
                        }
                        finally {
                            if (jarFile != null) {
                                try {
                                    jarFile.close();
                                }
                                catch (IOException e) {
                                    this.logException("findInMetaInfResource", filename, jarFile, e);
                                }
                            }
                        }
                    }
                }
            }
            if (this.normalFile == null && this.metaInfResFile == null) continue;
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "findInMetaInfResource", new Object[]{this.normalFile, this.metaInfResFile});
        }
    }

    private void logException(String methodName, String filename, JarFile jarFile, IOException e) {
        String jarFileName = null;
        jarFileName = jarFile != null ? jarFile.getName() : "";
        Object[] args = new Object[]{e, jarFileName, filename};
        logger.logp(Level.SEVERE, CLASS_NAME, methodName, "ioexception.searching.jar.for.resource", args);
    }

    public Set<String> getResourcePaths(String filename) {
        HashSet setOfUrls = new HashSet();
        return this.getResourcePaths(this.libBinFiles, "META-INF/resources" + filename, setOfUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Set<String> getResourcePaths(File[] searchPath, String filename, Set setOfUrls) {
        if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
            MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "searchPath-->" + Arrays.toString(searchPath) + ", filename --> " + filename);
        }
        fc = 0;
        if (searchPath == null) {
            if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "unable to get file listing for directory");
            }
            return setOfUrls;
        }
        jarSearchNameWithoutEndingSlash = filename;
        jarSearchNameWithEndingSlash = filename;
        if (jarSearchNameWithoutEndingSlash.endsWith("/")) {
            jarSearchNameWithoutEndingSlash = jarSearchNameWithoutEndingSlash.substring(0, jarSearchNameWithoutEndingSlash.length() - 1);
        } else {
            jarSearchNameWithEndingSlash = jarSearchNameWithEndingSlash + "/";
        }
        while (fc < searchPath.length) {
            curFile = searchPath[fc];
            if (curFile.isDirectory()) {
                if (this.recurseDirs) {
                    if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                        MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "recursing to find more jar files");
                    }
                    subDirSearchPath = curFile.listFiles();
                    this.getResourcePaths(subDirSearchPath, filename, setOfUrls);
                } else {
                    try {
                        basePath = curFile.getCanonicalPath();
                        fullTestPath = basePath + "/" + filename;
                        if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                            MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "looking for [{0}] in basePath[{1}] loose config", new Object[]{fullTestPath, basePath});
                        }
                        if (!(tempDir = new File(fullTestPath)).exists()) ** GOTO lbl83
                        fullRootLength = basePath.length() + 19;
                        if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                            MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "found dir in loose config");
                        }
                        children = tempDir.listFiles();
                        for (i = 0; i < children.length; ++i) {
                            pathToAdd = children[i].toString().substring(fullRootLength);
                            if (File.separatorChar != '/') {
                                pathToAdd = pathToAdd.replace(File.separatorChar, '/');
                            }
                            if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                                MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "loose config child[{0}], pathToAdd[{1}]", new Object[]{children[i], pathToAdd});
                            }
                            if (children[i].isDirectory()) {
                                pathToAdd = pathToAdd + "/";
                            }
                            setOfUrls.add(pathToAdd);
                        }
                    }
                    catch (IOException e) {
                        args = new Object[]{e};
                        MetaInfResourcesFileUtils.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "Engine.Exception.[{0}]", args);
                    }
                }
            } else {
                curFileName = curFile.getName();
                if (curFileName.toLowerCase().endsWith(".jar")) {
                    jarFile = null;
                    try {
                        jarFile = new JarFile(curFile);
                        zipEntry = jarFile.getEntry(jarSearchNameWithoutEndingSlash);
                        if (zipEntry == null) {
                            if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                                MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "curFileName-->" + curFileName + ", no suitable entries for :" + jarSearchNameWithoutEndingSlash);
                            }
                        } else {
                            entries = jarFile.entries();
                            if (TraceComponent.isAnyTracingEnabled() && MetaInfResourcesFileUtils.logger.isLoggable(Level.FINE)) {
                                MetaInfResourcesFileUtils.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils", "getResourcePaths", "curFileName-->" + curFileName + ", entries --> " + entries);
                            }
                            origName = null;
                            while (entries.hasMoreElements()) {
                                currentEntry = entries.nextElement();
                                origName = currentEntry.getName();
                                if (origName.length() <= jarSearchNameWithEndingSlash.length() || !origName.startsWith(jarSearchNameWithEndingSlash) || (slashIndex = origName.indexOf(47, jarSearchNameWithEndingSlash.length())) != -1 && slashIndex != origName.length() - 1) continue;
                                setOfUrls.add(origName.substring(18));
                            }
                        }
                    }
                    catch (IOException e) {
                        this.logException("getResourcePaths", filename, jarFile, e);
                    }
                    finally {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {
                                this.logException("getResourcePaths", filename, jarFile, e);
                            }
                        }
                    }
                }
            }
            ++fc;
        }
        return setOfUrls;
    }

    public InputStream getInputStream() {
        try {
            if (this.metaInfResFile != null) {
                return this.metaInfResFile.getIS();
            }
            if (this.normalFile != null) {
                return new FileInputStream(this.normalFile);
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{e};
            logger.logp(Level.SEVERE, CLASS_NAME, "getInputStream", "Engine.Exception.[{0}]", args);
        }
        return null;
    }

    public File getMatchedStaticFile() {
        return this.normalFile;
    }

    public URL getURL() {
        try {
            if (this.metaInfResFile != null) {
                return this.metaInfResFile.getURL();
            }
            if (this.normalFile != null) {
                return this.normalFile.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            Object[] args = new Object[]{e};
            logger.logp(Level.SEVERE, CLASS_NAME, "getURL", "Engine.Exception.[{0}]", args);
        }
        return null;
    }

    public ZipFileResource getMatchedZipFile() {
        return this.metaInfResFile;
    }

    public String getFilePath() {
        try {
            if (this.normalFile != null) {
                return this.normalFile.getCanonicalPath();
            }
            if (this.metaInfResFile != null) {
                return this.metaInfResFile.getMatch().getCanonicalPath();
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{e};
            logger.logp(Level.SEVERE, CLASS_NAME, "getFilePath", "Engine.Exception.[{0}]", args);
        }
        return null;
    }
}

