/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.handle.HandleListInterface;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.security.auth.Subject;

public class HCMDetails
implements HandleListInterface.HandleDetails,
PrivilegedAction<StackTraceElement[]> {
    private static final TraceComponent tc = Tr.register(HCMDetails.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.cm.internal.resources.J2CAMessages");
    private static final AtomicBoolean connectionLeakOccurred = new AtomicBoolean();
    private static final AtomicBoolean connectionLeakStackReported = new AtomicBoolean();
    public final ConnectionManager _cm;
    public final Object _handle;
    public MCWrapper _mcWrapper;
    public final Subject _subject;
    public final ConnectionRequestInfo _cRequestInfo;
    private StackTraceElement[] stackOfAllocateConnection;

    HCMDetails(ConnectionManager cm, Object handle, MCWrapper mcWrapper, Subject subject, ConnectionRequestInfo cRequestInfo) {
        this._cm = cm;
        this._handle = handle;
        this._mcWrapper = mcWrapper;
        this._subject = subject;
        this._cRequestInfo = cRequestInfo;
        if (connectionLeakOccurred.get() && !connectionLeakStackReported.get()) {
            this.stackOfAllocateConnection = AccessController.doPrivileged(this);
        }
    }

    public void close(boolean leaked) {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object[])new Object[]{leaked ? "leaked " + this._handle : this._handle});
            }
            try {
                if (leaked && !connectionLeakOccurred.compareAndSet(false, true) && this.stackOfAllocateConnection != null) {
                    if (connectionLeakStackReported.compareAndSet(false, true)) {
                        Tr.info((TraceComponent)tc, (String)"CONNECTION_LEAK_DETECTED_J2CA8070", (Object[])new Object[]{this._cm.gConfigProps.cfName, this.printableStackOfAllocate()});
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Connection leak detected for " + this._cm.gConfigProps.cfName + ". Stack of allocate:"), (Object[])new Object[]{this.printableStackOfAllocate()});
                    }
                }
                if (this._handle instanceof java.sql.Connection) {
                    ((java.sql.Connection)this._handle).close();
                } else if (this._handle instanceof Connection) {
                    ((Connection)this._handle).close();
                } else {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            Method m = HCMDetails.this._handle.getClass().getMethod("close", new Class[0]);
                            m.invoke(HCMDetails.this._handle, new Object[0]);
                            return null;
                        }
                    });
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"close");
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block12;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"close", (Object)e);
            }
        }
    }

    public boolean forHandle(Object h) {
        boolean isMyHandle = this._handle.equals(h);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("forHandle " + h + "? " + isMyHandle), (Object[])new Object[0]);
        }
        return isMyHandle;
    }

    public void park() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"park", (Object[])new Object[]{this._handle});
        }
        try {
            this._cm.parkHandle(this);
        }
        catch (IllegalStateException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"error is expected if it follows a transaction timeout", (Object[])new Object[]{e});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"373", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"park", (Object)e);
            }
            RuntimeException re = new RuntimeException("parkHandle call Failed");
            re.initCause(e);
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"park");
        }
    }

    private String printableStackOfAllocate() {
        String EOLN = String.format("%n", new Object[0]);
        StringBuilder s = new StringBuilder();
        boolean include = false;
        for (StackTraceElement line : this.stackOfAllocateConnection) {
            if (include) {
                s.append(EOLN).append("    ").append(line);
                continue;
            }
            include = "<init>".equals(line.getMethodName());
        }
        return s.toString();
    }

    public void reassociate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"reassociate", (Object[])new Object[]{this._handle});
        }
        try {
            this._cm.reAssociate(this);
        }
        catch (IllegalStateException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"error is expected if it follows a transaction timeout", (Object[])new Object[]{e});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"297", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate", (Object)e);
            }
            RuntimeException re = new RuntimeException("Reassociate call Failed");
            re.initCause(e);
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociate");
        }
    }

    @Override
    public StackTraceElement[] run() {
        return Thread.currentThread().getStackTrace();
    }
}

