/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.jaeger.adapter;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppLibraryClassLoader
extends URLClassLoader {
    private final Map<String, Class<?>> interfaces;

    public AppLibraryClassLoader(URL[] implementationUrls, List<Class<?>> interfaces, ClassLoader parent) {
        super(implementationUrls, parent);
        this.interfaces = interfaces.stream().collect(Collectors.toMap(c -> c.getCanonicalName(), c -> c));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String nname = name.replace('$', '.');
        Class<?> result = this.interfaces.get(nname);
        if (result == null) {
            result = super.findClass(name);
        }
        return result;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        AllPermission allPermission = new AllPermission();
        PermissionCollection collection = allPermission.newPermissionCollection();
        collection.add(allPermission);
        return collection;
    }
}

