/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.parsers.EsaParser;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.PaxParser;
import com.ibm.ws.repository.parsers.ProductParser;
import com.ibm.ws.repository.parsers.ProductZipParser;
import com.ibm.ws.repository.parsers.SamplesParser;
import com.ibm.ws.repository.parsers.ToolParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CreateJsonRepositoryFiles
extends Task {
    private File assetFile;
    private File metadataFile;
    private String assetType;
    private ResourceType assetTypeEnumValue;
    private String outputLocation;
    static final long serialVersionUID = 5422947215124446331L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        System.out.println("CreateJsonRepositoryFiles called with following parameters");
        System.out.println("- AssetFile      = " + this.getAssetFile().getAbsolutePath());
        String metadataFileAbsPath = this.getMetadataFile() == null ? "null" : this.getMetadataFile().getAbsolutePath();
        System.out.println("- MetadataFile   = " + metadataFileAbsPath);
        System.out.println("- AssetType      = " + this.getAssetType());
        System.out.println("- OutputLocation = " + this.getOutputLocation());
        try {
            this.assetTypeEnumValue = ResourceType.valueOf((String)this.assetType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void iae;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", (String)"50", (Object)((Object)this), (Object[])new Object[0]);
            iae.printStackTrace();
            throw new BuildException((Throwable)iae);
        }
        OutputStream os = null;
        Parser parser = null;
        try {
            switch (this.assetTypeEnumValue) {
                case PRODUCTSAMPLE: 
                case OPENSOURCE: {
                    parser = new SamplesParser();
                    break;
                }
                case CONFIGSNIPPET: {
                    break;
                }
                case ADMINSCRIPT: {
                    break;
                }
                case TOOL: {
                    parser = new ToolParser();
                    break;
                }
                case ADDON: 
                case INSTALL: {
                    if (this.isPax(this.assetFile)) {
                        parser = new PaxParser();
                        break;
                    }
                    if (this.isZip(this.assetFile)) {
                        parser = new ProductZipParser();
                        break;
                    }
                    parser = new ProductParser();
                    break;
                }
                case FEATURE: {
                    parser = new EsaParser();
                    break;
                }
                case IFIX: {
                    break;
                }
            }
            if (parser != null) {
                Object resource = parser.parseFileToResource(this.assetFile, this.metadataFile, null);
                resource.updateGeneratedFields(true);
                os = this.getOutputStreamFromPath(this.getOutputLocation(), this.assetFile);
                resource.writeDiskRepoJSONToStream(os);
            }
        }
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", (String)"112", (Object)((Object)this), (Object[])new Object[0]);
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (parser == null) throw throwable;
                    parser.tidyUp();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", (String)"124", (Object)((Object)this), (Object[])new Object[0]);
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            if (os != null) {
                os.close();
            }
            if (parser == null) return;
            parser.tidyUp();
            return;
        }
        catch (IOException resource) {
            FFDCFilter.processException((Throwable)resource, (String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", (String)"124", (Object)((Object)this), (Object[])new Object[0]);
            e.printStackTrace();
            return;
        }
    }

    private boolean isPax(File f) {
        return f.getName().toLowerCase().endsWith(".pax");
    }

    private boolean isZip(File f) {
        return f.getName().toLowerCase().endsWith(".zip");
    }

    /*
     * WARNING - void declaration
     */
    private OutputStream getOutputStreamFromPath(String path, File ipFile) {
        path = path + "/" + ipFile.getName() + ".json";
        FileOutputStream os = null;
        try {
            File f = new File(path);
            System.out.println("Writing json to " + f.getAbsolutePath());
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            os = new FileOutputStream(f);
        }
        catch (IOException f) {
            void e;
            FFDCFilter.processException((Throwable)f, (String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", (String)"152", (Object)((Object)this), (Object[])new Object[]{path, ipFile});
            e.printStackTrace();
        }
        return os;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public File getAssetFile() {
        return this.assetFile;
    }

    public void setAssetFile(File assetFile) {
        this.assetFile = assetFile;
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile.getName().equalsIgnoreCase("null") ? null : metadataFile;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.CreateJsonRepositoryFiles", CreateJsonRepositoryFiles.class, null, null);
    }
}

