/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.IdentifyExceptionAs;
import com.ibm.ws.rsadapter.SQLStateAndCode;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.impl.ConnectionResults;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import org.ietf.jgss.GSSCredential;

public class DatabaseHelper {
    private static final com.ibm.ejs.ras.TraceComponent databaseTc = Tr.register((String)"com.ibm.ws.database.logwriter", (String)"WAS.database", null);
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(DatabaseHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    transient PrintWriter genPw;
    public Object dataStoreHelper;
    String dataStoreHelperClassName = "com.ibm.websphere.rsadapter.GenericDataStoreHelper";
    protected int defaultQueryTimeout;
    private String databaseProductName = null;
    private String driverName;
    int driverMajorVersion;
    private Method doConnectionCleanup;
    private Method doConnectionCleanupPerCloseConnection;
    private Method doConnectionSetup;
    private Method doConnectionSetupPerGetConnection;
    private Method doConnectionSetupPerTransaction;
    private Method doStatementCleanup;
    private Method modifyXAFlag;
    public boolean isCustomHelper;
    WSManagedConnectionFactoryImpl mcf;
    protected boolean holdabilitySupported = true;
    private boolean setCursorNameSupported = true;
    final Set<Object> staleConCodes = new HashSet<Object>();
    final Set<Object> staleStmtCodes = new HashSet<Object>();
    boolean xaEndResetsAutoCommit;

    DatabaseHelper(WSManagedConnectionFactoryImpl mcf) {
        this.mcf = mcf;
        Properties props = mcf.dsConfig.get().vendorProps;
        Object queryTimeout = props.get("queryTimeout");
        try {
            this.defaultQueryTimeout = queryTimeout instanceof Number ? ((Number)queryTimeout).intValue() : (queryTimeout instanceof String ? Integer.parseInt((String)queryTimeout) : 0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"init", (Object[])new Object[]{"Default query timeout=" + this.defaultQueryTimeout});
        }
        Collections.addAll(this.staleConCodes, "08001", "08003", "08006", "08S01", "40003", "55032", "S1000");
    }

    public boolean alwaysSetAutoCommit() {
        return false;
    }

    final void createDataStoreHelper() throws Exception {
        DSConfig config = this.mcf.dsConfig.get();
        Properties helperProps = new Properties();
        Object value = config.vendorProps.get("currentSQLID");
        if (value != null) {
            helperProps.setProperty("currentSQLID", value.toString());
        }
        helperProps.setProperty("dataSourceClass", this.mcf.vendorImplClass.getName());
        value = config.vendorProps.get("driverType");
        if (value != null) {
            helperProps.put("driverType", value.toString());
        }
        if ((value = config.vendorProps.get("informixAllowNewLine")) != null) {
            helperProps.put("informixAllowNewLine", value.toString());
        }
        if ((value = config.vendorProps.get("longDataCacheSize")) != null) {
            helperProps.put("longDataCacheSize", value.toString());
        }
        if (config.queryTimeout != null) {
            helperProps.put("queryTimeout", Integer.toString(config.queryTimeout));
        }
        if ((value = config.vendorProps.get("responseBuffering")) != null) {
            helperProps.put("responseBuffering", value.toString());
        }
        if (config.isolationLevel != -1) {
            helperProps.put("webSphereDefaultIsolationLevel", Integer.toString(config.isolationLevel));
        }
        String helperClassName = config.heritageHelperClass == null ? this.dataStoreHelperClassName : config.heritageHelperClass;
        this.isCustomHelper = !helperClassName.startsWith("com.ibm.websphere.rsadapter");
        HashMap<Object, Class> map = new HashMap<Object, Class>();
        for (Map.Entry<Object, String> entry : config.identifyExceptions.entrySet()) {
            try {
                String className = entry.getValue();
                if (!className.contains(".")) {
                    try {
                        IdentifyExceptionAs identifyAs = IdentifyExceptionAs.valueOf(className);
                        className = identifyAs.legacyClassName == null ? IdentifyExceptionAs.None.legacyClassName : identifyAs.legacyClassName;
                    }
                    catch (IllegalArgumentException identifyAs) {
                        // empty catch block
                    }
                }
                Class exceptionClass = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, className);
                Object key = entry.getKey();
                if (key instanceof String || key instanceof Integer) {
                    map.put(key, exceptionClass);
                    continue;
                }
                throw new IllegalArgumentException(com.ibm.websphere.ras.Tr.formatMessage((TraceComponent)tc, (String)"8068_EXC_REPLACE_CONFLICT", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName}));
            }
            catch (ClassNotFoundException x) {
                com.ibm.websphere.ras.Tr.error((TraceComponent)tc, (String)"8066E_IDENTIFY_EXCEPTION_INVALID_TARGET", (Object[])new Object[]{entry.getValue(), Arrays.toString((Object[])IdentifyExceptionAs.values())});
                throw x;
            }
        }
        try {
            this.dataStoreHelper = AccessController.doPrivileged(() -> {
                Class<?> c = this.mcf.jdbcDriverLoader.loadClass(helperClassName);
                Object h = c.getConstructor(Properties.class).newInstance(helperProps);
                c.getMethod("setConfig", Object.class).invoke(h, this.mcf.dsConfig);
                if (this.genPw == null) {
                    this.genPw = (PrintWriter)c.getMethod("getPrintWriter", new Class[0]).invoke(h, new Object[0]);
                }
                Class<?> AccessIntent = this.mcf.jdbcDriverLoader.loadClass("com.ibm.websphere.appprofile.accessintent.AccessIntent");
                this.mcf.defaultIsolationLevel = (Integer)c.getMethod("getIsolationLevel", AccessIntent).invoke(h, new Object[]{null});
                if (!map.isEmpty()) {
                    c.getMethod("setUserDefinedMap", Map.class).invoke(h, map);
                }
                Object metadata = c.getMethod("getMetaData", new Class[0]).invoke(h, new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"createDataStoreHelper", (Object[])new Object[]{this.dataStoreHelper, metadata, map});
                }
                this.doConnectionCleanup = c.getMethod("doConnectionCleanup", Connection.class);
                this.doConnectionCleanupPerCloseConnection = c.getMethod("doConnectionCleanupPerCloseConnection", Connection.class, Boolean.TYPE, Object.class);
                this.doConnectionSetup = c.getMethod("doConnectionSetup", Connection.class);
                this.doConnectionSetupPerGetConnection = c.getMethod("doConnectionSetupPerGetConnection", Connection.class, Boolean.TYPE, Object.class);
                this.doConnectionSetupPerTransaction = c.getMethod("doConnectionSetupPerTransaction", Subject.class, String.class, Connection.class, Boolean.TYPE, Object.class);
                this.doStatementCleanup = c.getMethod("doStatementCleanup", PreparedStatement.class);
                this.modifyXAFlag = c.getMethod("modifyXAFlag", Integer.TYPE);
                Class<?> mdc = metadata.getClass();
                this.mcf.doesStatementCacheIsoLevel = (Boolean)mdc.getMethod("doesStatementCacheIsoLevel", new Class[0]).invoke(metadata, new Object[0]);
                this.mcf.supportsGetCatalog = (Boolean)mdc.getMethod("supportsGetCatalog", new Class[0]).invoke(metadata, new Object[0]);
                this.mcf.supportsGetNetworkTimeout = (Boolean)mdc.getMethod("supportsGetNetworkTimeout", new Class[0]).invoke(metadata, new Object[0]);
                this.mcf.supportsGetSchema = (Boolean)mdc.getMethod("supportsGetSchema", new Class[0]).invoke(metadata, new Object[0]);
                this.mcf.supportsGetTypeMap = (Boolean)mdc.getMethod("supportsGetTypeMap", new Class[0]).invoke(metadata, new Object[0]);
                this.mcf.supportsIsReadOnly = (Boolean)mdc.getMethod("supportsIsReadOnly", new Class[0]).invoke(metadata, new Object[0]);
                return h;
            });
        }
        catch (Throwable x) {
            if (x instanceof PrivilegedActionException) {
                x = x.getCause();
            }
            if (x instanceof InvocationTargetException) {
                x = x.getCause();
            }
            com.ibm.websphere.ras.Tr.error((TraceComponent)tc, (String)"8069_HELPER_INIT_ERR", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName, helperClassName, x});
            if (x instanceof Exception) {
                throw (Exception)x;
            }
            throw (Error)x;
        }
    }

    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        if (this.dataStoreHelper != null) {
            return this.doConnectionCleanupLegacy(conn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup: no cleanup is done return false", (Object[])new Object[0]);
        }
        return false;
    }

    final boolean doConnectionCleanupLegacy(Connection con) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> (Boolean)this.doConnectionCleanup.invoke(this.dataStoreHelper, WSJdbcTracer.getImpl(con)));
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"370", (Object)this);
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
    }

    public final SQLException doConnectionCleanupPerCloseConnection(Connection con) {
        try {
            Connection conn = this.isCustomHelper ? (Connection)WSJdbcTracer.getImpl(con) : con;
            boolean conCleanupPerformed = AccessController.doPrivileged(() -> (Boolean)this.doConnectionCleanupPerCloseConnection.invoke(this.dataStoreHelper, conn, false, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection", (Object[])new Object[]{this.dataStoreHelper, con, conCleanupPerformed});
            }
            return null;
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            Throwable throwable = cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection", (Object[])new Object[]{x});
            }
            if (cause instanceof SQLException) {
                return AdapterUtil.mapSQLException((SQLException)cause, (Object)this.mcf);
            }
            return new SQLException(x.getMessage(), null, 999999);
        }
    }

    public void doConnectionSetup(Connection conn) throws SQLException {
        if (this.dataStoreHelper != null) {
            this.doConnectionSetupLegacy(conn);
            return;
        }
    }

    final void doConnectionSetupLegacy(Connection con) throws SQLException {
        Connection conn = this.isCustomHelper ? (Connection)WSJdbcTracer.getImpl(con) : con;
        try {
            AccessController.doPrivileged(() -> {
                this.doConnectionSetup.invoke(this.dataStoreHelper, conn);
                return null;
            });
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"448", (Object)this);
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
    }

    final void doConnectionSetupPerGetConnection(Connection con, Subject subject) throws ResourceException {
        try {
            HashMap<String, Subject> props = new HashMap<String, Subject>();
            props.put("SUBJECT", subject);
            Connection conn = this.isCustomHelper ? (Connection)WSJdbcTracer.getImpl(con) : con;
            boolean conSetupPerformed = AccessController.doPrivileged(() -> (Boolean)this.doConnectionSetupPerGetConnection.invoke(this.dataStoreHelper, conn, false, props));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionSetupPerGetConnection", (Object[])new Object[]{this.dataStoreHelper, this, con, conSetupPerformed});
            }
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"435", (Object)this);
            if (cause instanceof SQLException) {
                cause = AdapterUtil.mapSQLException((SQLException)cause, (Object)this.mcf);
            }
            throw new DataStoreAdapterException("DSA_ERROR", cause, this.getClass(), new Object[0]);
        }
    }

    final void doConnectionSetupPerTransaction(Subject subject, String user, Connection con, boolean reauthRequired, Properties props) throws ResourceException {
        try {
            Connection conn = this.isCustomHelper ? (Connection)WSJdbcTracer.getImpl(con) : con;
            AccessController.doPrivileged(() -> {
                this.doConnectionSetupPerTransaction.invoke(this.dataStoreHelper, subject, user, conn, reauthRequired, props);
                return null;
            });
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"433", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", cause, this.getClass(), new Object[0]);
        }
    }

    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        block5: {
            if (this.dataStoreHelper != null) {
                this.doStatementCleanupLegacy(stmt);
                return;
            }
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (this.setCursorNameSupported) {
                try {
                    stmt.setCursorName(null);
                }
                catch (SQLFeatureNotSupportedException supportX) {
                    this.setCursorNameSupported = false;
                    if (!isTraceOn || !tc.isDebugEnabled()) break block5;
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"Statement.setCursorName() is not supported.", (Object[])new Object[]{supportX});
                }
            }
        }
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    final void doStatementCleanupLegacy(PreparedStatement stmt) throws SQLException {
        try {
            PreparedStatement s = this.isCustomHelper ? (PreparedStatement)WSJdbcTracer.getImpl(stmt) : stmt;
            AccessController.doPrivileged(() -> {
                this.doStatementCleanup.invoke(this.dataStoreHelper, s);
                return null;
            });
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"573", (Object)this);
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
    }

    public boolean failoverOccurred(SQLException sqlX) {
        return false;
    }

    public boolean getRRSTransactional() {
        return false;
    }

    public int getThreadIdentitySupport() {
        return 0;
    }

    public boolean getThreadSecurity() {
        return false;
    }

    public Object getLargeObjectAPI(Connection con) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return databaseTc;
    }

    public long getUpdateCount(WSJdbcStatement stmt) throws SQLException {
        return stmt.getCompatibleUpdateCount();
    }

    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        return null;
    }

    public String getXAExceptionContents(XAException x) {
        if (this.dataStoreHelper != null) {
            try {
                return AccessController.doPrivileged(() -> (String)this.dataStoreHelper.getClass().getMethod("getXAExceptionContents", XAException.class).invoke(this.dataStoreHelper, x));
            }
            catch (PrivilegedActionException ex) {
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"623", (Object)this);
            }
        }
        StringBuilder xsb = new StringBuilder(200);
        Throwable cause = x.getCause();
        if (cause != null) {
            String EOLN = AdapterUtil.EOLN;
            xsb.append(EOLN).append("Caused by ").append(cause.getClass().getName()).append(": ").append(cause.getMessage()).append(EOLN);
            if (cause instanceof SQLException) {
                SQLException sqlX = (SQLException)cause;
                xsb.append("The error code is: ").append(sqlX.getErrorCode()).append(EOLN);
                xsb.append("The SQL State is: ").append(sqlX.getSQLState()).append(EOLN);
            }
        }
        return xsb.toString();
    }

    final void initUOWDetection() throws SQLException {
        try {
            this.mcf.supportsUOWDetection = AccessController.doPrivileged(() -> {
                Object metadata = this.dataStoreHelper.getClass().getMethod("getMetaData", new Class[0]).invoke(this.dataStoreHelper, new Object[0]);
                return (Boolean)metadata.getClass().getMethod("supportsUOWDetection", new Class[0]).invoke(metadata, new Object[0]);
            });
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            Throwable throwable = cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
    }

    public boolean isConnectionError(SQLException ex) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.dataStoreHelper != null) {
            try {
                return AccessController.doPrivileged(() -> (Boolean)this.dataStoreHelper.getClass().getMethod("isConnectionError", SQLException.class).invoke(this.dataStoreHelper, ex));
            }
            catch (PrivilegedActionException x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"673", (Object)this);
            }
        }
        DSConfig config = this.mcf.dsConfig.get();
        HashSet<SQLException> chain = new HashSet<SQLException>();
        boolean stale = false;
        for (Throwable t = ex; !stale && t != null && chain.add((SQLException)t); t = t.getCause()) {
            if (t instanceof SQLException) {
                String target;
                SQLException sqlX = t;
                String sqlState = sqlX.getSQLState();
                int errorCode = sqlX.getErrorCode();
                SQLStateAndCode combo = sqlState == null ? null : new SQLStateAndCode(sqlState, errorCode);
                String string = target = combo == null ? null : config.identifyExceptions.get(combo);
                if (target == null && (target = config.identifyExceptions.get(errorCode)) == null && sqlState != null) {
                    target = config.identifyExceptions.get(sqlState);
                }
                if (target == null) {
                    stale = sqlX instanceof SQLRecoverableException || sqlX instanceof SQLNonTransientConnectionException || sqlX instanceof SQLTransientConnectionException && this.failoverOccurred(sqlX) || combo != null && this.staleConCodes.contains(combo) || this.staleConCodes.contains(errorCode) || sqlState != null && this.staleConCodes.contains(sqlState);
                } else {
                    stale = IdentifyExceptionAs.StaleConnection.name().equals(target);
                    if (!stale && target.contains(".")) {
                        try {
                            for (Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, target); !stale && c != null; c = c.getSuperclass()) {
                                stale = c.getClass().getName().equals(IdentifyExceptionAs.StaleConnection.legacyClassName);
                            }
                        }
                        catch (ClassNotFoundException cnfx) {
                            com.ibm.websphere.ras.Tr.error((TraceComponent)tc, (String)"8066E_IDENTIFY_EXCEPTION_INVALID_TARGET", (Object[])new Object[]{target, Arrays.toString((Object[])IdentifyExceptionAs.values())});
                        }
                    }
                }
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isConnectionError? " + stale + ": " + sqlState + ' ' + errorCode + ' ' + sqlX.getClass().getName()), (Object[])new Object[0]);
                continue;
            }
            if (!isTraceOn || !tc.isDebugEnabled()) continue;
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isConnectionError? " + stale + ": " + t.getClass().getName()), (Object[])new Object[0]);
        }
        return stale;
    }

    public final boolean isStaleStatement(SQLException x) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        DSConfig config = this.mcf.dsConfig.get();
        HashSet<SQLException> chain = new HashSet<SQLException>();
        boolean stale = false;
        for (Throwable t = x; !stale && t != null && chain.add((SQLException)t); t = t.getCause()) {
            if (t instanceof SQLException) {
                String target;
                SQLException sqlX = t;
                String sqlState = sqlX.getSQLState();
                int errorCode = sqlX.getErrorCode();
                SQLStateAndCode combo = sqlState == null ? null : new SQLStateAndCode(sqlState, errorCode);
                String string = target = combo == null ? null : config.identifyExceptions.get(combo);
                if (target == null && (target = config.identifyExceptions.get(errorCode)) == null && sqlState != null) {
                    target = config.identifyExceptions.get(sqlState);
                }
                if (target == null) {
                    stale = combo != null && this.staleStmtCodes.contains(combo) || this.staleStmtCodes.contains(errorCode) || sqlState != null && this.staleStmtCodes.contains(sqlState);
                } else {
                    stale = IdentifyExceptionAs.StaleStatement.name().equals(target);
                    if (!stale && target.contains(".")) {
                        try {
                            for (Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, target); !stale && c != null; c = c.getSuperclass()) {
                                stale = c.getClass().getName().equals(IdentifyExceptionAs.StaleStatement.legacyClassName);
                            }
                        }
                        catch (ClassNotFoundException cnfx) {
                            com.ibm.websphere.ras.Tr.error((TraceComponent)tc, (String)"8066E_IDENTIFY_EXCEPTION_INVALID_TARGET", (Object[])new Object[]{target, Arrays.toString((Object[])IdentifyExceptionAs.values())});
                        }
                    }
                }
                if (!trace || !tc.isDebugEnabled()) continue;
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isStaleStatement? " + stale + ": " + sqlState + ' ' + errorCode + ' ' + sqlX.getClass().getName()), (Object[])new Object[0]);
                continue;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isStaleStatement? " + stale + ": " + t.getClass().getName()), (Object[])new Object[0]);
        }
        return stale;
    }

    final boolean isUnsupported(SQLException sqlX) {
        String target;
        DSConfig config = this.mcf.dsConfig.get();
        boolean unsupported = false;
        String sqlState = sqlX.getSQLState();
        int errorCode = sqlX.getErrorCode();
        SQLStateAndCode combo = sqlState == null ? null : new SQLStateAndCode(sqlState, errorCode);
        String string = target = combo == null ? null : config.identifyExceptions.get(combo);
        if (target == null && (target = config.identifyExceptions.get(errorCode)) == null && sqlState != null) {
            target = config.identifyExceptions.get(sqlState);
        }
        if (target == null) {
            if (this.dataStoreHelper == null) {
                unsupported = sqlX instanceof SQLFeatureNotSupportedException || sqlState != null && sqlState.startsWith("0A") || 40960 == errorCode || sqlState != null && sqlState.startsWith("HYC00") || errorCode == -79700 && "IX000".equals(sqlState);
            } else {
                try {
                    unsupported = AccessController.doPrivileged(() -> (Boolean)this.dataStoreHelper.getClass().getMethod("isUnsupported", SQLException.class).invoke(this.dataStoreHelper, sqlX));
                }
                catch (PrivilegedActionException x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"799", (Object)this);
                }
            }
        } else {
            unsupported = IdentifyExceptionAs.Unsupported.name().equals(target);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isUnsupported? " + unsupported + ": " + sqlState + ' ' + errorCode + ' ' + sqlX.getClass().getName()), (Object[])new Object[0]);
        }
        return unsupported;
    }

    public final SQLException mapException(SQLException sqlX) {
        try {
            return AccessController.doPrivileged(() -> {
                Method mapException = this.dataStoreHelper.getClass().getMethod("mapException", SQLException.class);
                return (SQLException)mapException.invoke(this.dataStoreHelper, sqlX);
            });
        }
        catch (PrivilegedActionException x) {
            FFDCFilter.processException((Throwable)x, (String)DatabaseHelper.class.getName(), (String)"819", (Object)this);
            return sqlX;
        }
    }

    final int modifyXAFlag(int xaStartFlags) {
        try {
            return AccessController.doPrivileged(() -> (Integer)this.modifyXAFlag.invoke(this.dataStoreHelper, xaStartFlags));
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            cause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
            FFDCFilter.processException((Throwable)x, (String)DatabaseHelper.class.getName(), (String)"839", (Object)this);
            throw new RuntimeException(cause);
        }
    }

    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return databaseTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !databaseTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        mc.mcf.reallySetLogWriter(null);
        mc.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"enabling logging", (Object[])new Object[]{mcf, pw});
        }
        mcf.reallySetLogWriter(pw);
        mcf.loggingEnabled = true;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        this.enableJdbcLogging(mc.mcf);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(databaseTc), true);
        }
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.genPw});
        }
        return this.genPw;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        managedConn.setReadOnly(readOnly);
    }

    public int getHoldability(Connection conn) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        int holdability = 0;
        try {
            if (this.holdabilitySupported) {
                holdability = conn.getHoldability();
                return holdability;
            }
            return 0;
        }
        catch (AbstractMethodError ame) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (UnsupportedOperationException uex) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.UnsupportedOperationException"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sqe) {
            if (this.isConnectionError(sqe)) {
                throw sqe;
            }
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", (Object[])new Object[]{sqe});
            }
            this.holdabilitySupported = false;
            return 0;
        }
    }

    public boolean isIsolationLevelSwitchingSupport() {
        return false;
    }

    public void psSetBytes(PreparedStatement pstmtImpl, int i, byte[] x) throws SQLException {
        pstmtImpl.setBytes(i, x);
    }

    public void psSetString(PreparedStatement pstmtImpl, int i, String x) throws SQLException {
        pstmtImpl.setString(i, x);
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    void setDriverMajorVersion(int version) {
        this.driverMajorVersion = version;
    }

    void setDriverName(String name) {
        this.driverName = name;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    String getDriverName() {
        return this.driverName;
    }

    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.mcf.jdbcDriverSpecVersion >= 40 && (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"resetClientInformation", (Object[])new Object[]{mc});
            }
            try {
                mc.sqlConn.setClientInfo(mc.mcf.defaultClientInfo);
                mc.clientInfoExplicitlySet = false;
                mc.clientInfoImplicitlySet = false;
            }
            catch (SQLException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + "resetClientInformation"), (String)"780", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"resetClientInformation", (Object)ex);
                }
                throw AdapterUtil.mapSQLException(ex, mc);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"resetClientInformation");
            }
        }
    }

    public Object getSQLJContext(WSRdbManagedConnectionImpl mc, Class<?> DefaultContext, WSConnectionManager connMgr) throws SQLException {
        return null;
    }

    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        DatabaseMetaData mData;
        block31: {
            block30: {
                String databaseProductVersion;
                String driverVersion;
                String driverName;
                String databaseProductName;
                block29: {
                    mData = conn.getMetaData();
                    databaseProductName = mData.getDatabaseProductName();
                    driverName = mData.getDriverName();
                    driverVersion = null;
                    databaseProductVersion = null;
                    try {
                        driverVersion = mData.getDriverVersion();
                        databaseProductVersion = mData.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block29;
                        com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception occurred while getting metaData info. Exception is: ", (Object[])new Object[]{e});
                    }
                }
                this.setDatabaseProductName(databaseProductName);
                this.setDriverName(driverName);
                this.setDriverMajorVersion(mData.getDriverMajorVersion());
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object[])new Object[]{databaseProductName});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object[])new Object[]{databaseProductVersion});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object[])new Object[]{driverName});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object[])new Object[]{driverVersion});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"exception identification", (Object[])new Object[]{"stale connection: " + this.staleConCodes, "stale statement:  " + this.staleStmtCodes, "overrides: " + mcf.dsConfig.get().identifyExceptions});
                }
                try {
                    if (mData.supportsResultSetHoldability(1) && mData.supportsResultSetHoldability(2)) {
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Holdabiliy is supported", (Object[])new Object[0]);
                        }
                        this.holdabilitySupported = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Holdability not supported", (Object[])new Object[0]);
                        }
                        this.holdabilitySupported = false;
                    }
                }
                catch (Throwable x) {
                    if (x instanceof SQLException) {
                        SQLException sqe = (SQLException)x;
                        if (this.isConnectionError(sqe)) {
                            throw sqe;
                        }
                        this.holdabilitySupported = false;
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", (Object[])new Object[]{sqe});
                        }
                    }
                    if (!tc.isDebugEnabled()) break block30;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", (Object[])new Object[]{x});
                }
            }
            try {
                mcf.jdbcDriverSpecVersion = mData.getJDBCMajorVersion() * 10;
            }
            catch (AbstractMethodError methError) {
                mcf.jdbcDriverSpecVersion = 20;
            }
            catch (UnsupportedOperationException supportX) {
                mcf.jdbcDriverSpecVersion = 20;
            }
            catch (SQLException sqlX) {
                mcf.jdbcDriverSpecVersion = 20;
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"metadata.getJDBCMajorVersion", (Object[])new Object[]{sqlX});
                }
                if (!this.isConnectionError(sqlX)) break block31;
                throw sqlX;
            }
        }
        if (mcf.jdbcDriverSpecVersion > 30) {
            try {
                mcf.jdbcDriverSpecVersion += mData.getJDBCMinorVersion();
            }
            catch (SQLException sqlX) {
            }
            catch (UnsupportedOperationException sqlX) {
                // empty catch block
            }
        }
        if (mcf.jdbcDriverSpecVersion >= 40) {
            try {
                Properties clientInfo = conn.getClientInfo();
                if (clientInfo != null) {
                    mcf.defaultClientInfo.putAll((Map<?, ?>)clientInfo);
                }
            }
            catch (SQLFeatureNotSupportedException featureX) {
                com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"FEATURE_NOT_IMPLEMENTED", (Object[])new Object[]{"java.sql.Connection.getClientInfo"});
            }
            catch (AbstractMethodError methErr) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("JDBC spec level, " + mcf.jdbcDriverSpecVersion + ", reported by the driver is not valid. Using 30 (3.0) instead."), (Object[])new Object[0]);
                }
                mcf.jdbcDriverSpecVersion = 30;
            }
            catch (UnsupportedOperationException operationX) {
                com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"FEATURE_NOT_IMPLEMENTED", (Object[])new Object[]{"java.sql.Connection.getClientInfo"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"JDBC spec version implemented by driver", (Object[])new Object[]{mcf.jdbcDriverSpecVersion});
        }
    }

    public boolean isInDatabaseUnitOfWork(Connection conn) throws SQLException {
        com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"UNSUPPORTED_METHOD", (Object[])new Object[]{"isInDatabaseUnitOfWork"});
        throw new SQLException("method not supported for this backend database");
    }

    public Connection getConnectionFromDatasource(DataSource ds, WSManagedConnectionFactoryImpl.KerbUsage useKerb, Object gssCredential) throws SQLException {
        return ds.getConnection();
    }

    public ConnectionResults getPooledConnection(final CommonDataSource ds, String userName, String password, final boolean is2Phase, final WSConnectionRequestInfoImpl cri, WSManagedConnectionFactoryImpl.KerbUsage useKerberos, Object gssCredential) throws ResourceException {
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object[])new Object[]{AdapterUtil.toString(ds), userName, "******", is2Phase ? "two-phase" : "one-phase", cri, useKerberos, gssCredential});
        }
        if (useKerberos == WSManagedConnectionFactoryImpl.KerbUsage.USE_CREDENTIAL) {
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"KERBEROS_NOT_SUPPORTED_WARNING", (Object[])new Object[0]);
        }
        try {
            final String user = userName == null ? null : userName.trim();
            final String pwd = password == null ? null : password.trim();
            PooledConnection pConn = AccessController.doPrivilegedWithCombiner(new PrivilegedExceptionAction<PooledConnection>(){

                @Override
                public PooledConnection run() throws SQLException {
                    boolean buildConnection;
                    boolean bl = buildConnection = cri.ivShardingKey != null || cri.ivSuperShardingKey != null;
                    if (is2Phase) {
                        if (buildConnection) {
                            return DatabaseHelper.this.mcf.jdbcRuntime.buildXAConnection((XADataSource)ds, user, pwd, cri);
                        }
                        if (user == null) {
                            return ((XADataSource)ds).getXAConnection();
                        }
                        return ((XADataSource)ds).getXAConnection(user, pwd);
                    }
                    if (buildConnection) {
                        return DatabaseHelper.this.mcf.jdbcRuntime.buildPooledConnection((ConnectionPoolDataSource)ds, user, pwd, cri);
                    }
                    if (user == null) {
                        return ((ConnectionPoolDataSource)ds).getPooledConnection();
                    }
                    return ((ConnectionPoolDataSource)ds).getPooledConnection(user, pwd);
                }
            });
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)AdapterUtil.toString(pConn));
            }
            return new ConnectionResults(pConn, null);
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)this.getClass().getName(), (String)"1298");
            DataStoreAdapterException resX = new DataStoreAdapterException("JAVAX_CONN_ERR", pae.getException(), DatabaseHelper.class, is2Phase ? "XAConnection" : "PooledConnection");
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)this.getClass().getName(), (String)"1312");
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Caught ClassCastException", (Object[])new Object[]{castX});
            }
            DataStoreAdapterException resX = new DataStoreAdapterException(castX.getMessage(), null, DatabaseHelper.class, is2Phase ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS");
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
    }

    public void setClientRerouteData(Object dataSource, String cRJNDIName, String cRAlternateServer, String cRAlternatePort, String cRPrimeServer, String cRPrimePort, Context jndiContext, String driverType) throws Throwable {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Client reroute is not supported on non-DB2 JCC driver.", (Object[])new Object[0]);
        }
    }

    public final boolean isAnAuthorizationException(SQLException x) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        DSConfig config = this.mcf.dsConfig.get();
        boolean isAuthError = false;
        LinkedList<SQLException> stack = new LinkedList<SQLException>();
        if (x != null) {
            stack.push(x);
        }
        for (int depth = 0; depth < 20 && !isAuthError && !stack.isEmpty(); ++depth) {
            String target;
            x = (SQLException)stack.pop();
            String sqlState = x.getSQLState();
            int errorCode = x.getErrorCode();
            SQLStateAndCode combo = sqlState == null ? null : new SQLStateAndCode(sqlState, errorCode);
            String string = target = combo == null ? null : config.identifyExceptions.get(combo);
            if (target == null && (target = config.identifyExceptions.get(errorCode)) == null && sqlState != null) {
                target = config.identifyExceptions.get(sqlState);
            }
            isAuthError = target == null ? this.isAuthException(x) : IdentifyExceptionAs.AuthorizationError.name().equals(target);
            if (isTraceOn && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("isAnAuthorizationException? " + isAuthError + ": " + sqlState + ' ' + errorCode + ' ' + x.getClass().getName()), (Object[])new Object[0]);
            }
            if (x.getNextException() != null) {
                stack.push(x.getNextException());
            }
            if (!(x.getCause() instanceof SQLException) || x.getCause() == x.getNextException()) continue;
            stack.push((SQLException)x.getCause());
        }
        return isAuthError;
    }

    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28");
    }

    public void reuseKerbrosConnection(Connection sqlConn, GSSCredential gssCred, Properties props) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Kerberos reuse is not supported when using generic helper.  No-op operation.", (Object[])new Object[0]);
        }
    }

    public int branchCouplingSupported(int couplingType) {
        int result;
        int n = result = couplingType == 0 && this.dataStoreHelper != null ? this.modifyXAFlag(0) : 0;
        if (couplingType == 0 && result == 0 || couplingType == 1) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Specified branch coupling type not supported", (Object[])new Object[0]);
            }
            result = -1;
        }
        return result;
    }

    public int getDefaultBranchCoupling() {
        return -1;
    }

    public Map<String, Object> cacheVendorConnectionProps(Connection connImpl) throws SQLException {
        return null;
    }

    public boolean doConnectionVendorPropertyReset(Connection sqlConn, Map<String, Object> props) throws SQLException {
        return false;
    }

    public boolean supportsSubjectDoAsForKerberos() {
        return false;
    }
}

