/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public final class Util {
    static final String digits = "0123456789abcdef";
    public static Class[] noParameters = new Class[0];

    public static String identity(Object x) {
        if (x == null) {
            return "" + x;
        }
        return x.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(x));
    }

    public static String identity(Object[] x) {
        if (x == null) {
            return "" + null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < x.length; ++i) {
            sb.append(x[i].getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(x[i])));
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean sameByteArray(byte[] a, byte[] b) {
        return Util.equal(a, b);
    }

    public static boolean equal(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] byteArray(String s) {
        return Util.byteArray(s, false);
    }

    public static byte[] byteArray(String s, boolean keepBothBytes) {
        byte[] result = new byte[s.length() * (keepBothBytes ? 2 : 1)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = keepBothBytes ? (byte)(s.charAt(i / 2) >> (i & 1) * 8) : (byte)s.charAt(i);
        }
        return result;
    }

    public static String toString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            result.append((char)b[i]);
        }
        return result.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(digits.charAt(b[i] >> 4 & 0xF));
            result.append(digits.charAt(b[i] & 0xF));
        }
        return result.toString();
    }

    public static byte[] fromHexString(String s) {
        byte[] result = new byte[s.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)((digits.indexOf(s.charAt(2 * i)) << 4) + digits.indexOf(s.charAt(2 * i + 1)));
        }
        return result;
    }

    public static void Assert(boolean b) {
        if (!b) {
            throw new Fatal("assertion failure");
        }
    }

    public static void Exception() {
    }

    public static void Warning(String s) {
        System.out.println("TRAN WARNING: " + s);
    }

    public static void apply(Object[] a, Executor e) {
        Util.apply(a, null, e);
    }

    public static void apply(Object[] a, Object context, Executor e) {
        if (a == null) {
            return;
        }
        e.setContext(context);
        for (int i = 0; i < a.length; ++i) {
            e.execute(a[i]);
        }
    }

    public static void apply(Vector v, Executor e) {
        Util.apply(v, null, e);
    }

    public static void apply(Vector v, Object context, Executor e) {
        if (v == null) {
            return;
        }
        e.setContext(context);
        Enumeration l = v.elements();
        while (l.hasMoreElements()) {
            e.execute(l.nextElement());
        }
    }

    public static Object[] extend(Object[] newList, Object[] oldList, Object addition) {
        for (int i = 0; i < oldList.length; ++i) {
            newList[i] = oldList[i];
        }
        newList[oldList.length] = addition;
        return newList;
    }

    public static Object extend(Object[] oldList, Object addition) {
        if (oldList == null) {
            oldList = new Object[]{};
        }
        Object result = Array.newInstance(addition.getClass(), oldList.length + 1);
        System.arraycopy(oldList, 0, result, 0, oldList.length);
        ((Object[])result)[oldList.length] = addition;
        return result;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static String dump(Object o, boolean inherited, String separator) {
        try {
            Class<?> c = o.getClass();
            StringBuffer result = new StringBuffer();
            boolean first = true;
            do {
                Field[] f = c.getDeclaredFields();
                for (int i = 0; i < f.length; ++i) {
                    if (!first) {
                        result.append(separator);
                    }
                    result.append(f[i].getName());
                    result.append('=');
                    first = false;
                    try {
                        Object d = f[i].get(o);
                        result.append(d == null ? "null" : d.toString());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        try {
                            Method m = c.getDeclaredMethod(f[i].getName(), noParameters);
                            Object d = m.invoke(o, (Object[])noParameters);
                            result.append(d == null ? "null" : d.toString());
                            continue;
                        }
                        catch (Throwable t) {
                            result.append("<inaccessible>");
                        }
                    }
                }
            } while (!inherited || (c = c.getSuperclass()) != null);
            return result.toString();
        }
        catch (Throwable t) {
            return "<exception " + t.toString() + ">";
        }
    }

    public class Executor {
        private Object context;

        final void setContext(Object o) {
            this.context = o;
        }

        final Object getContext() {
            return this.context;
        }

        void execute(Object o) {
        }
    }

    static class Fatal
    extends Error {
        private static final long serialVersionUID = 5772669795196571203L;

        Fatal(String s) {
            try {
                System.out.println("Fatal error: " + s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static interface Dumpable {
        public String dump();
    }
}

