/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl;
import com.ibm.ws.concurrent.internal.ScheduledTask;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.resource.ResourceFactory;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.concurrent.Trigger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.managedScheduledExecutorService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ExecutorService.class, ManagedExecutorService.class, ResourceFactory.class, ApplicationRecycleComponent.class, ScheduledExecutorService.class, ManagedScheduledExecutorService.class}, reference={@Reference(name="ApplicationRecycleCoordinator", service=ApplicationRecycleCoordinator.class)})
public class ManagedScheduledExecutorServiceImpl
extends ManagedExecutorServiceImpl
implements ManagedScheduledExecutorService {
    private static final TraceComponent tc = Tr.register(ManagedScheduledExecutorServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private static final int FUTURE_PURGE_INTERVAL = 20;
    private volatile int futureCount;
    private final ConcurrentLinkedQueue<ScheduledFuture<?>> futures = new ConcurrentLinkedQueue();
    ScheduledExecutorService scheduledExecSvc;
    static final long serialVersionUID = -677695089393536066L;

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Future future = this.futures.poll();
        while (future != null) {
            if (!future.isDone() && future.cancel(true) && trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"canceled scheduled task", (Object[])new Object[]{future});
            }
            future = this.futures.poll();
        }
        super.deactivate(context);
    }

    @Trivial
    private final void purgeFutures() {
        Iterator<ScheduledFuture<?>> it = this.futures.iterator();
        while (it.hasNext()) {
            if (!it.next().isDone()) continue;
            it.remove();
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(this, task, true, delay, null, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, Trigger trigger) {
        if (trigger == null) {
            throw new NullPointerException(Trigger.class.getName());
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, true, trigger);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, delay, null, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        if (trigger == null) {
            throw new NullPointerException(Trigger.class.getName());
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, trigger);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (period <= 0L) {
            throw new IllegalArgumentException(Long.toString(period));
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, initialDelay < 0L ? 0L : initialDelay, null, period, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException(Long.toString(delay));
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, initialDelay < 0L ? 0L : initialDelay, delay, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    @Trivial
    @Reference(target="(deferrable=false)")
    protected void setScheduledExecutor(ScheduledExecutorService svc) {
        this.scheduledExecSvc = svc;
    }

    @Trivial
    protected void unsetScheduledExecutor(ScheduledExecutorService svc) {
        this.scheduledExecSvc = null;
    }
}

