/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.jaxrs20.api.EndpointPublisher;
import com.ibm.ws.jaxrs20.endpoint.JaxRsPublisherContext;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.server.deprecated.JaxRsExtensionProcessor;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.jaxrs20.server.extensionFactory", immediate=true, property={"service.vendor=IBM"})
public class JaxRsExtensionFactory
implements ExtensionFactory {
    private static final TraceComponent tc = Tr.register(JaxRsExtensionFactory.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    private final AtomicServiceReference<EndpointPublisher> endpointPublisherSR = new AtomicServiceReference("WebEndpointPublisher");
    static final long serialVersionUID = 9167282774476881038L;

    @Reference(name="WebEndpointPublisher", service=EndpointPublisher.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setWebEndpointPublisher(ServiceReference<EndpointPublisher> publisher) {
        this.endpointPublisherSR.setReference(publisher);
    }

    protected void unsetWebEndpointPublisher(ServiceReference<EndpointPublisher> publisher) {
        this.endpointPublisherSR.unsetReference(publisher);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.endpointPublisherSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.endpointPublisherSR.deactivate(cc);
    }

    public ExtensionProcessor createExtensionProcessor(IServletContext servletContext) throws Exception {
        WebModuleMetaData moduleMetaData = ((WebAppConfigExtended)servletContext.getWebAppConfig()).getMetaData();
        JaxRsModuleMetaData jaxRsModuleMetaData = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData);
        if (jaxRsModuleMetaData == null) {
            return null;
        }
        NonPersistentCache overlayCache = (NonPersistentCache)servletContext.getModuleContainer().adapt(NonPersistentCache.class);
        JaxRsModuleInfo jaxRsModuleInfo = (JaxRsModuleInfo)overlayCache.getFromCache(JaxRsModuleInfo.class);
        if (jaxRsModuleInfo == null || jaxRsModuleInfo.endpointInfoSize() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JAX-RS service is found in the web module, will not create web service processor", (Object[])new Object[0]);
            }
            return null;
        }
        Container publisherModuleContainer = servletContext.getModuleContainer();
        JaxRsPublisherContext publisherContext = new JaxRsPublisherContext(jaxRsModuleMetaData, publisherModuleContainer, (ModuleInfo)JaxRsUtils.getWebModuleInfo((Container)publisherModuleContainer));
        publisherContext.setAttribute("SERVLET_CONTEXT", (Object)servletContext);
        WebApp webApp = (WebApp)servletContext;
        publisherContext.setAttribute("collaborator", (Object)webApp.getCollaboratorHelper().getWebAppNameSpaceCollaborator());
        EndpointPublisher endpointPublisher = (EndpointPublisher)this.endpointPublisherSR.getServiceWithException();
        for (EndpointInfo endpointInfo : jaxRsModuleInfo.getEndpointInfos()) {
            endpointPublisher.publish(endpointInfo, publisherContext);
        }
        return new JaxRsExtensionProcessor(servletContext);
    }

    public List getPatternList() {
        return Collections.emptyList();
    }
}

