/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.licensing;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import wlp.lib.extract.SelfExtract;

public class LicenseUpgradeUtility {
    private String productId;
    private String productOwner;
    private String productVersion;
    private String productName;
    private String productReplaces;
    private String productInstallType;
    private String productEdition;
    private String productLicenseType;
    private String wlpDir;
    private List<String> features;
    private boolean acceptLicense;
    Set<InstallLicense> featureLicenses = Collections.emptySet();
    private static final String UNSPECIFIED_LICENSE_TYPE = "UNSPECIFIED";
    final String WEBSPHERE_PROPERTIES_FILE_DIR = "/lib/versions/";
    final String WEBSPHERE_PROPERTIES_FILE_NAME = "WebsphereApplicationServer.properties";

    public LicenseUpgradeUtility(LicenseUpgradeUtilityBuilder builder) {
        this.productId = builder.productId;
        this.productOwner = builder.productOwner;
        this.productVersion = builder.productVersion;
        this.productName = builder.productName != null ? builder.productName : "Websphere Application Server";
        this.productReplaces = builder.productReplaces != null ? builder.productReplaces : "io.openliberty";
        this.productInstallType = builder.productInstallType;
        this.productEdition = builder.productEdition;
        this.productLicenseType = builder.productLicenseType;
        this.wlpDir = builder.wlpDir != null ? builder.wlpDir : Utils.getInstallDir().getAbsolutePath();
        this.features = builder.features;
    }

    public void generateWebspherePropertiesFile() {
        String propertiesDir = this.wlpDir + "/lib/versions/" + "WebsphereApplicationServer.properties";
        Properties prop = new Properties();
        FileInputStream input = null;
        try (FileOutputStream os = new FileOutputStream(propertiesDir);){
            input = new FileInputStream(propertiesDir);
            prop.load(input);
            prop.setProperty("com.ibm.websphere.productId", this.productId);
            prop.setProperty("com.ibm.websphere.productReplaces", this.productReplaces);
            prop.setProperty("com.ibm.websphere.productOwner", this.productOwner);
            prop.setProperty("com.ibm.websphere.productVersion", this.productVersion);
            prop.setProperty("com.ibm.websphere.productNane", this.productName);
            prop.setProperty("com.ibm.websphere.productInstallType", this.productInstallType);
            prop.setProperty("com.ibm.websphere.productEdition", this.productEdition);
            prop.setProperty("com.ibm.websphere.productLicense", this.productLicenseType);
            prop.store(os, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean handleLicenses() {
        if (this.acceptLicense) {
            return true;
        }
        InstallKernelInteractive installKernel = InstallKernelFactory.getInteractiveInstance();
        try {
            installKernel.resolve(this.features, false);
            this.featureLicenses = installKernel.getFeatureLicense(Locale.getDefault());
            Set licenseToAccept = InstallUtils.getLicenseToAccept(this.featureLicenses);
            if (!this.acceptLicense) {
                if (!licenseToAccept.isEmpty()) {
                    this.showFeaturesForLicenseAcceptance(licenseToAccept);
                }
                for (InstallLicense license : licenseToAccept) {
                    if (this.handleLicenseAcceptance(license)) continue;
                    return false;
                }
            }
        }
        catch (ProductInfoParseException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (DuplicateProductInfoException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (ProductInfoReplaceException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (InstallException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean handleLicenseAcceptance(InstallLicense licenseToAccept) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseStatement", (Object[])new Object[]{licenseToAccept.getProgramName(), licenseToAccept.getName()}));
        System.out.println();
        return this.obtainLicenseAgreement(licenseToAccept);
    }

    private boolean obtainLicenseAgreement(InstallLicense license) {
        if (this.featureLicenses.size() > 1) {
            SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showAgreement", (Object)"--viewLicenseAgreement"));
            boolean view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptAgreement"), (String)"", (String)"xX");
            if (view) {
                System.out.println(license.getAgreement());
                System.out.println();
            }
            SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showInformation", (Object)"--viewLicenseInfo"));
            view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptInfo"), (String)"", (String)"xX");
            if (view) {
                System.out.println(license.getInformation());
                System.out.println();
            }
        } else {
            System.out.println();
            System.out.println(license.getAgreement());
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
        System.out.println();
        return accept;
    }

    private void showFeaturesForLicenseAcceptance(Set<InstallLicense> licenseToAccept) {
        HashSet<String> featuresToAccept = new HashSet<String>();
        StringBuffer buf = new StringBuffer();
        for (InstallLicense license : licenseToAccept) {
            String featureToMatch = this.getFeaturesForLicense(license);
            if (featureToMatch.isEmpty()) continue;
            featuresToAccept.add(featureToMatch);
            buf.append(featureToMatch);
        }
        String featuresToAcceptMsg = buf.toString().trim();
    }

    private String getFeaturesForLicense(InstallLicense license) {
        StringBuffer buf = new StringBuffer();
        for (String feature : license.getFeatures()) {
            for (String featureToMatch : this.features) {
                if (!feature.contains(featureToMatch)) continue;
                buf.append(featureToMatch + " ");
            }
        }
        String matchedFeatures = buf.toString();
        return matchedFeatures;
    }

    public static class LicenseUpgradeUtilityBuilder {
        String productId;
        String productOwner;
        String productVersion;
        String productName;
        String productReplaces;
        String productInstallType;
        String productEdition;
        String productLicenseType;
        String wlpDir;
        List<String> features;

        public LicenseUpgradeUtilityBuilder setProductId(String productId) {
            this.productId = productId;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductOwner(String productOwner) {
            this.productOwner = productOwner;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductReplaces(String productReplaces) {
            this.productReplaces = productReplaces;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductInstallType(String productInstallType) {
            this.productInstallType = productInstallType;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductEdition(String productEdition) {
            this.productEdition = productEdition;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductLicenseType(String productLicenseType) {
            this.productLicenseType = productLicenseType;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setWlpDir(String wlpDir) {
            this.wlpDir = wlpDir;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setFeatures(List<String> features) {
            this.features = features;
            return this;
        }

        public LicenseUpgradeUtility build() {
            return new LicenseUpgradeUtility(this);
        }
    }
}

