/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.library.internal.LibraryGeneration;
import com.ibm.ws.library.internal.SharedLibraryImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.config.FilesetChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class FilesetListener
implements FilesetChangeListener {
    private static final TraceComponent tc = Tr.register(FilesetListener.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final SharedLibraryImpl library;
    private final LibraryGeneration generation;
    private final Collection<Fileset> filesets;
    private final Collection<ServiceRegistration<?>> filesetListenerRegs;
    private volatile Set<? extends String> outstandingPids;
    private final AtomicInteger numOutstanding;
    static final long serialVersionUID = -6000250256832494583L;

    @FFDCIgnore(value={IllegalStateException.class})
    FilesetListener(SharedLibraryImpl library, LibraryGeneration generation, List<? extends String> filesetRefs, Collection<Fileset> filesets, Collection<ServiceRegistration<?>> filesetListenerRegs) {
        this.library = library;
        this.generation = generation;
        this.filesets = filesets;
        this.filesetListenerRegs = filesetListenerRegs;
        this.outstandingPids = new ConcurrentSkipListSet<String>(filesetRefs);
        this.numOutstanding = new AtomicInteger(filesetRefs.size());
        for (String string : this.outstandingPids) {
            ServiceRegistration reg;
            if (generation.isCancelled()) {
                return;
            }
            Hashtable<String, String> listenerProps = new Hashtable<String, String>(1);
            ((Dictionary)listenerProps).put("fileset", string);
            try {
                reg = library.ctx.registerService(FilesetChangeListener.class, (Object)this, listenerProps);
                if (generation.isCancelled()) {
                    reg.unregister();
                    return;
                }
            }
            catch (IllegalStateException e) {
                return;
            }
            filesetListenerRegs.add(reg);
        }
    }

    public void filesetNotification(String pid, Fileset fileset) {
        if (this.generation.isCancelled()) {
            return;
        }
        if (this.numOutstanding.get() == 0) {
            this.library.notifyListeners();
            return;
        }
        if (this.outstandingPids.remove(pid)) {
            this.filesets.add(fileset);
            if (this.numOutstanding.decrementAndGet() == 0) {
                this.outstandingPids = Collections.emptySet();
                this.library.publishGeneration(this.generation);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("received additional notification for fileset " + pid + " while still waiting for filesets " + this.outstandingPids), (Object[])new Object[0]);
        }
    }
}

