/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExampleProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParameterProcessor {
    private final ResolverCache cache;
    private final SchemaProcessor schemaProcessor;
    private final ExampleProcessor exampleProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = 7718650806612271343L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ParameterProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processParameter(Parameter parameter) {
        Object newRef;
        RefFormat refFormat;
        String $ref = parameter.getRef();
        if ($ref != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat(parameter.getRef())) && (newRef = this.externalRefProcessor.processRefToExternalParameter($ref, refFormat)) != null) {
            parameter.setRef((String)newRef);
        }
        if (parameter.getSchema() != null) {
            this.schemaProcessor.processSchema(parameter.getSchema());
        }
        if (parameter.getExamples() != null) {
            Map examples = parameter.getExamples();
            for (String exampleName : examples.keySet()) {
                Example example = (Example)examples.get(exampleName);
                this.exampleProcessor.processExample(example);
            }
        }
        Schema schema = null;
        if (parameter.getContent() != null) {
            Content content = parameter.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }

    public List<Parameter> processParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Parameter> processedPathLevelParameters = new ArrayList<Parameter>();
        ArrayList refParameters = new ArrayList();
        for (Parameter parameter : parameters) {
            if (parameter.getRef() != null) {
                RefFormat refFormat = RefUtils.computeRefFormat(parameter.getRef());
                Parameter resolvedParameter = this.cache.loadRef(parameter.getRef(), refFormat, Parameter.class);
                if (resolvedParameter == null) {
                    processedPathLevelParameters.add(parameter);
                    continue;
                }
                boolean matched = false;
                for (Parameter param : processedPathLevelParameters) {
                    if (!param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                for (Parameter param : parameters) {
                    if (param.getName() == null || !param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                processedPathLevelParameters.add(resolvedParameter);
                continue;
            }
            processedPathLevelParameters.add(parameter);
        }
        block3: for (Parameter resolvedParameter : refParameters) {
            int pos = 0;
            for (Parameter param : processedPathLevelParameters) {
                if (param.getName().equals(resolvedParameter.getName())) {
                    processedPathLevelParameters.set(pos, resolvedParameter);
                    continue block3;
                }
                ++pos;
            }
        }
        return processedPathLevelParameters;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.ParameterProcessor", ParameterProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

