/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.ContactValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.examples.Example;

public class ExampleValidator
extends TypeValidator<Example> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class);
    private static final ExampleValidator INSTANCE = new ExampleValidator();

    public static ExampleValidator getInstance() {
        return INSTANCE;
    }

    private ExampleValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Example t) {
        if (t != null) {
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getValue() != null && t.getExternalValue() != null && !t.getExternalValue().isEmpty()) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"exampleOnlyValueOrExternalValue", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
        }
    }
}

