/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BeanManagerInvocationHandler
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(BeanManagerInvocationHandler.class, null, null);
    private final CDIService cdiService;
    private Object target;
    private IBMHibernateExtendedBeanManager extendedBeanManager;
    static final long serialVersionUID = -6062966338264471293L;

    BeanManagerInvocationHandler(CDIService cdiService) {
        this.cdiService = cdiService;
    }

    BeanManagerInvocationHandler(CDIService cdiService, IBMHibernateExtendedBeanManager extendedBeanManager) {
        this.cdiService = cdiService;
        this.extendedBeanManager = extendedBeanManager;
    }

    public String toString() {
        return super.toString() + '[' + this.target + ']';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={InvocationTargetException.class})
    public Object invoke(@Sensitive Object proxy, Method method, @Sensitive Object[] args) throws Throwable {
        Object ret;
        String methodName = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if ("toString".equals(methodName)) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(proxy)) + '[' + this + ']';
            }
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(methodName)) {
                return this.getTarget().hashCode();
            }
            throw new UnsupportedOperationException(method.toString());
        }
        try {
            if (methodName.equals("registerLifecycleListener")) {
                if (args.length != 1) {
                    throw new IllegalStateException("registerLifecycleListener should have one argument");
                }
                Object listener = args[0];
                Method proxyMethod = this.extendedBeanManager.getClass().getMethod("registerLifecycleListener", Object.class);
                ret = proxyMethod.invoke((Object)this.extendedBeanManager, listener);
            } else {
                ret = method.invoke(this.getTarget(), args);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoked BeanManager method", (Object[])new Object[]{this.cdiService, method, args, ret});
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Throwable e) {
            void t;
            Object[] objectArray = new Object[3];
            objectArray[0] = "<sensitive java.lang.Object>";
            objectArray[1] = method;
            objectArray[2] = "<sensitive java.lang.Object[]>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.BeanManagerInvocationHandler", (String)"85", (Object)this, (Object[])objectArray);
            throw new IllegalStateException((Throwable)t);
        }
        return ret;
    }

    private synchronized Object getTarget() {
        if (this.target == null) {
            BeanManager bm = this.cdiService.getCurrentModuleBeanManager();
            if (bm == null) {
                bm = this.cdiService.getCurrentBeanManager();
            }
            if (bm == null) {
                throw new UnsupportedOperationException("No current bean manager found in CDI service");
            }
            this.target = bm;
        }
        return this.target;
    }
}

