/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.genericbnf.internal.HeaderHandler;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.hpack.H2Headers;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.internal.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.HeaderStorage;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.DebugLog;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpResponseMessageImpl
extends HttpBaseMessageImpl
implements HttpResponseMessage {
    private static final TraceComponent tc = Tr.register(HttpResponseMessageImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final long serialVersionUID = 7629585068712704258L;
    private static final byte[] NOCACHE_VALUE = GenericUtils.getEnglishBytes("no-cache=\"set-cookie, set-cookie2\"");
    private static final byte[] LONG_AGO = GenericUtils.getEnglishBytes("Thu, 01 Dec 1994 16:00:00 GMT");
    private transient StatusCodes myStatusCode = StatusCodes.OK;
    private byte[] myReasonBytes = null;
    private transient String myReason = null;

    public HttpResponseMessageImpl() {
        this.setOwner(null);
        this.setBinaryParseState(14);
    }

    public HttpResponseMessageImpl(HttpInboundServiceContext isc) {
        this.setOwner(isc);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public HttpResponseMessageImpl(HttpOutboundServiceContext osc) {
        this.setOwner(osc);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext sc) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext sc) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext sc, BNFHeaders hdrs) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext sc, BNFHeaders hdrs) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
    }

    private void initVersion() {
        VersionValues ver = this.getServiceContext().getRequestVersion();
        VersionValues configVer = this.getServiceContext().getHttpConfig().getOutgoingVersion();
        if (VersionValues.V10.equals(configVer) && VersionValues.V11.equals(ver)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configuration forcing 1.0 instead of 1.1", (Object[])new Object[0]);
            }
            this.setVersion(configVer);
        } else {
            this.setVersion(ver);
        }
    }

    public void setOwner(HttpServiceContext hsc) {
        if (null != this.getServiceContext()) {
            this.getServiceContext().setResponseOwner(false);
        }
        if (null != hsc) {
            super.init(hsc);
            this.getServiceContext().setResponseOwner(true);
            this.setIncoming(!this.getServiceContext().isInboundConnection());
            if (!this.isIncoming()) {
                this.setHeaderValidation(this.getServiceContext().getHttpConfig().isHeaderValidationEnabled());
            }
        }
    }

    @Override
    public boolean isBodyExpected() {
        if (VersionValues.V10.equals(this.getVersionValue())) {
            return this.isBodyAllowed();
        }
        if (this.getServiceContext().getRequestMethod().equals(MethodValues.HEAD)) {
            return false;
        }
        boolean rc = super.isBodyExpected();
        if (!rc) {
            boolean bl = rc = this.containsHeader(HttpHeaderKeys.HDR_CONTENT_ENCODING) || this.containsHeader(HttpHeaderKeys.HDR_CONTENT_RANGE);
        }
        if (rc) {
            rc = this.myStatusCode.isBodyAllowed();
        }
        return rc;
    }

    @Override
    public boolean isBodyAllowed() {
        if (super.isBodyAllowed()) {
            if (this.getServiceContext().getRequestMethod().equals(MethodValues.HEAD)) {
                return false;
            }
            return this.myStatusCode.isBodyAllowed();
        }
        return false;
    }

    @Override
    public boolean shouldUpdateBodyHeaders() {
        return !MethodValues.HEAD.equals(this.getServiceContext().getRequestMethod());
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Clearing this response: " + this), (Object[])new Object[0]);
        }
        super.clear();
        this.myStatusCode = StatusCodes.OK;
        this.myReason = null;
        this.myReasonBytes = null;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Destroying this response: " + this), (Object[])new Object[0]);
        }
        HttpObjectFactory tempFactory = this.getObjectFactory();
        super.destroy();
        if (null != tempFactory) {
            tempFactory.releaseResponse(this);
        }
    }

    @Override
    protected void setPseudoHeaders(HashMap<String, String> pseudoHeaders) throws Exception {
        for (Map.Entry<String, String> entry : pseudoHeaders.entrySet()) {
            H2HeaderField header = new H2HeaderField(entry.getKey(), entry.getValue());
            if (this.isValidPseudoHeader(header)) continue;
            ProtocolException pe = new ProtocolException("Invalid pseudo-header for decompression context: " + header.toString());
            pe.setConnectionError(false);
            throw pe;
        }
        this.setStatusCode(Integer.getInteger(pseudoHeaders.get(":status")));
    }

    @Override
    protected H2HeaderTable getH2HeaderTable() {
        if (this.getServiceContext() instanceof HttpInboundServiceContextImpl) {
            HttpInboundServiceContextImpl context = (HttpInboundServiceContextImpl)this.getServiceContext();
            return ((H2HttpInboundLinkWrap)context.getLink()).getWriteTable();
        }
        return null;
    }

    @Override
    protected boolean isValidPseudoHeader(H2HeaderField pseudoHeader) {
        if (!pseudoHeader.getValue().isEmpty()) {
            int hash = pseudoHeader.getNameHash();
            return hash == HpackConstants.STATUS_HASH;
        }
        return false;
    }

    @Override
    protected boolean checkMandatoryPseudoHeaders(HashMap<String, String> pseudoHeaders) {
        return pseudoHeaders.get(":status") != null;
    }

    @Override
    protected void setParsedFirstToken(byte[] token) throws Exception {
        this.setVersion(token);
    }

    @Override
    protected void setParsedSecondToken(byte[] token) throws Exception {
        this.setStatusCode(GenericUtils.asIntValue(token));
    }

    @Override
    protected void setParsedThirdToken(byte[] token) throws Exception {
        this.setReasonPhrase(token);
    }

    @Override
    protected byte[] getMarshalledFirstToken() {
        return this.getVersionValue().getByteArray();
    }

    @Override
    protected byte[] getMarshalledSecondToken() {
        return this.myStatusCode.getByteArray();
    }

    @Override
    protected byte[] getMarshalledThirdToken() {
        return this.getReasonPhraseBytes();
    }

    @Override
    public boolean parseBinaryFirstLine(WsByteBuffer buff) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseBinaryFirstLine for " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Buffer: " + buff), (Object[])new Object[0]);
        }
        if (this.getBinaryParseState() == 14) {
            if (!buff.hasRemaining()) {
                return false;
            }
            byte version = buff.get();
            if (version != 49) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unsupported binary version in message: " + version), (Object[])new Object[0]);
                }
                throw new MalformedMessageException("Invalid binary message");
            }
            this.setBinaryParseState(5);
            this.resetCacheToken(4);
        }
        boolean lineEnds = false;
        block7: while (!lineEnds) {
            if (!this.fillCacheToken(buff)) {
                return false;
            }
            switch (this.getBinaryParseState()) {
                case 5: {
                    int value = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (value & 0x20000)) {
                        this.setVersion(VersionValues.getByOrdinal(value));
                        this.setBinaryParseState(11);
                        this.resetCacheToken(4);
                        continue block7;
                    }
                    this.setBinaryParseState(6);
                    this.resetCacheToken(value & 0x1FFFF);
                    continue block7;
                }
                case 6: {
                    this.setVersion(VersionValues.find(this.getParsedToken()));
                    this.setBinaryParseState(11);
                    this.createCacheToken(4);
                    continue block7;
                }
                case 11: {
                    this.setStatusCode(GenericUtils.asInt(this.getParsedToken()));
                    this.setBinaryParseState(12);
                    this.resetCacheToken(4);
                    continue block7;
                }
                case 12: {
                    int value = GenericUtils.asInt(this.getParsedToken());
                    if (0 == value) {
                        this.setBinaryParseState(1);
                        this.resetCacheToken(4);
                        lineEnds = true;
                        continue block7;
                    }
                    this.setBinaryParseState(13);
                    this.resetCacheToken(value);
                    continue block7;
                }
                case 13: {
                    this.setReasonPhrase(this.getParsedToken());
                    this.setBinaryParseState(1);
                    this.createCacheToken(4);
                    lineEnds = true;
                    continue block7;
                }
            }
            throw new MalformedMessageException("Invalid state in line: " + this.getBinaryParseState());
        }
        this.setFirstLineComplete(true);
        return true;
    }

    @Override
    public WsByteBuffer[] marshallLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putBytes(this.getVersionValue().getByteArray(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        if (null == this.myReasonBytes) {
            firstLine = this.putBytes(this.myStatusCode.getStatusWithPhrase(), firstLine);
        } else {
            firstLine = this.putBytes(this.myStatusCode.getByteArray(), firstLine);
            firstLine = this.putByte((byte)32, firstLine);
            firstLine = this.putBytes(this.getReasonPhraseBytes(), firstLine);
        }
        firstLine = this.putBytes(BNFHeaders.EOL, firstLine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Marshalling first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase()), (Object[])new Object[0]);
        }
        return firstLine;
    }

    @Override
    public WsByteBuffer[] encodePseudoHeaders() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        HpackConstants.LiteralIndexType indexType = HpackConstants.LiteralIndexType.NOINDEXING;
        H2HeaderTable table = this.getH2HeaderTable();
        byte[] encodedHeader = null;
        try {
            encodedHeader = H2Headers.encodeHeader(table, ":status", this.getStatusCodeAsInt() + "", indexType);
            firstLine = this.putBytes(encodedHeader, firstLine);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Encoding first line status pseudoheader: :status :" + this.getStatusCodeAsInt()), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            firstLine[0].release();
            firstLine = null;
        }
        return firstLine;
    }

    @Override
    public WsByteBuffer[] marshallBinaryFirstLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putByte((byte)49, firstLine);
        if (this.getVersionValue().isUndefined()) {
            byte[] data = this.getVersionValue().getByteArray();
            firstLine = this.putInt(data.length | 0x20000, firstLine);
            firstLine = this.putBytes(data, firstLine);
        } else {
            firstLine = this.putInt(this.getVersionValue().getOrdinal(), firstLine);
        }
        firstLine = this.putInt(this.myStatusCode.getIntCode(), firstLine);
        if (null != this.myReasonBytes) {
            firstLine = this.putInt(this.myReasonBytes.length, firstLine);
            firstLine = this.putBytes(this.myReasonBytes, firstLine);
        } else {
            firstLine = this.putInt(0, firstLine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Marshalling binary first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase()), (Object[])new Object[0]);
        }
        return firstLine;
    }

    @Override
    protected void parsingComplete() throws MalformedMessageException {
        int num = this.getNumberFirstLineTokens();
        if (3 != num && 2 != num) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("numFirstLineTokensRead is " + this.getNumberFirstLineTokens()), (Object[])new Object[0]);
            }
            if (this.getServiceContext().getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                this.getServiceContext().getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "Invalid number of first line tokens", (HttpServiceContext)this.getServiceContext());
            }
            throw new MalformedMessageException("Received " + this.getNumberFirstLineTokens() + " first line tokens");
        }
    }

    @Override
    public void headerComplianceCheck() throws MessageSentException {
        byte[] serverHeader;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"headerComplianceCheck", (Object[])new Object[0]);
        }
        super.headerComplianceCheck();
        if (!this.containsHeader(HttpHeaderKeys.HDR_DATE)) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating a missing Date header", (Object[])new Object[0]);
            }
            this.setCurrentDate();
        }
        if (this.getServiceContext().getHttpConfig().removeServerHeader()) {
            if (this.containsHeader(HttpHeaderKeys.HDR_SERVER)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configuration forcing removal of Server header", (Object[])new Object[0]);
                }
                this.removeSpecialHeader(HttpHeaderKeys.HDR_SERVER);
            }
        } else if (!this.containsHeader(HttpHeaderKeys.HDR_SERVER) && null != (serverHeader = this.getServiceContext().getHttpConfig().getServerHeaderValue())) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_SERVER, serverHeader);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding the Server header value: " + this.getHeader(HttpHeaderKeys.HDR_SERVER).asString()), (Object[])new Object[0]);
            }
        }
        if (this.getServiceContext().getHttpConfig().shouldCookiesConfigureNoCache()) {
            this.updateCacheControl();
        }
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"headerComplianceCheck");
        }
    }

    private void updateCacheControl() {
        boolean addSet2;
        boolean addSet1 = this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE) || this.isCookieCacheDirty(HttpHeaderKeys.HDR_SET_COOKIE);
        boolean bl = addSet2 = this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE2) || this.isCookieCacheDirty(HttpHeaderKeys.HDR_SET_COOKIE2);
        if (!addSet1 && !addSet2) {
            return;
        }
        if (!this.containsHeader(HttpHeaderKeys.HDR_EXPIRES)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPIRES, LONG_AGO);
        }
        if (this.containsHeader(HttpHeaderKeys.HDR_CACHE_CONTROL)) {
            HeaderHandler handler = new HeaderHandler((HeaderStorage)this, ',', HttpHeaderKeys.HDR_CACHE_CONTROL);
            if (!handler.contains("no-cache")) {
                boolean updated = false;
                if (addSet1) {
                    updated = handler.add("no-cache", "set-cookie");
                }
                if (addSet2) {
                    updated = handler.add("no-cache", "set-cookie2") | updated;
                }
                if (updated) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Updating Cache-Control for Set-Cookie", (Object[])new Object[0]);
                    }
                    this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CACHE_CONTROL, handler.marshall());
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Adding Cache-Control due to Set-Cookie", (Object[])new Object[0]);
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CACHE_CONTROL, NOCACHE_VALUE);
        }
    }

    @Override
    public final int getStatusCodeAsInt() {
        return this.myStatusCode.getIntCode();
    }

    @Override
    public final StatusCodes getStatusCode() {
        return this.myStatusCode;
    }

    @Override
    public void setStatusCode(int code) {
        StatusCodes val = null;
        try {
            val = StatusCodes.getByOrdinal(code);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (null == val) {
            val = StatusCodes.makeUndefinedValue(code);
        }
        this.setStatusCode(val);
    }

    @Override
    public void setStatusCode(StatusCodes code) {
        if (!code.equals(this.myStatusCode)) {
            this.myStatusCode = code;
            this.myReason = null;
            this.myReasonBytes = null;
            super.setFirstLineChanged();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setStatusCode(sc): " + code), (Object[])new Object[0]);
        }
    }

    public boolean isTemporaryStatusCode() {
        int code = this.myStatusCode.getIntCode();
        if (HttpDispatcher.useEE7Streams() && code == 101) {
            return false;
        }
        return 100 <= code && 200 > code;
    }

    @Override
    public String getReasonPhrase() {
        if (null == this.myReason) {
            this.myReason = GenericUtils.getEnglishString(this.getReasonPhraseBytes());
        }
        return this.myReason;
    }

    @Override
    public byte[] getReasonPhraseBytes() {
        if (null == this.myReasonBytes) {
            return this.myStatusCode.getDefaultPhraseBytes();
        }
        return this.myReasonBytes;
    }

    @Override
    public void setReasonPhrase(String reason) {
        this.myReason = reason;
        this.myReasonBytes = GenericUtils.getEnglishBytes(reason);
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setReasonPhrase(String): set to [" + this.myReason + "]"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setReasonPhrase(byte[] reason) {
        this.myReasonBytes = reason;
        this.myReason = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            this.myReason = GenericUtils.getEnglishString(reason);
            Tr.event((TraceComponent)tc, (String)("setReasonPhrase(byte[]): set to [" + this.myReason + "]"), (Object[])new Object[0]);
        }
    }

    @Override
    public byte[] getCookieValue(String name) {
        if (null == name) {
            return null;
        }
        byte[] val = this.getCookieValue(name, HttpHeaderKeys.HDR_SET_COOKIE);
        if (null == val) {
            val = this.getCookieValue(name, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return val;
    }

    @Override
    public List<String> getAllCookieValues(String name) {
        LinkedList<String> list = new LinkedList<String>();
        if (null != name) {
            this.getAllCookieValues(name, HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.getAllCookieValues(name, HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookieValues: Found " + list.size() + " instances of " + name), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public HttpCookie getCookie(String name) {
        if (null == name) {
            return null;
        }
        HttpCookie cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE);
        if (null == cookie) {
            cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return null == cookie ? null : cookie.clone();
    }

    @Override
    public List<HttpCookie> getAllCookies() {
        LinkedList<HttpCookie> list = new LinkedList<HttpCookie>();
        this.getAllCookies(HttpHeaderKeys.HDR_SET_COOKIE, list);
        this.getAllCookies(HttpHeaderKeys.HDR_SET_COOKIE2, list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + list.size() + " instances"), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public List<HttpCookie> getAllCookies(String name) {
        LinkedList<HttpCookie> list = new LinkedList<HttpCookie>();
        if (null != name) {
            this.getAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.getAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + list.size() + " instances of " + name), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public boolean setCookie(HttpCookie cookie, HttpHeaderKeys header) {
        if (null == cookie || null == header) {
            return false;
        }
        if (1 < cookie.getVersion()) {
            throw new IllegalArgumentException("Cookie version is invalid: " + cookie.getVersion());
        }
        if (header.equals(HttpHeaderKeys.HDR_SET_COOKIE) || header.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            return this.addCookie(cookie, header);
        }
        return false;
    }

    @Override
    public boolean setCookie(String name, String value, HttpHeaderKeys header) {
        if (null == header) {
            return false;
        }
        return this.setCookie(new HttpCookie(name, value), header);
    }

    @Override
    public boolean removeCookie(String name, HttpHeaderKeys header) {
        if (null == name || null == header) {
            return false;
        }
        if (header.equals(HttpHeaderKeys.HDR_SET_COOKIE) || header.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            return this.deleteCookie(name, header);
        }
        return false;
    }

    @Override
    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Response Message: " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Status: " + this.getStatusCodeAsInt()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Reason: " + this.getReasonPhrase()), (Object[])new Object[0]);
            super.debug();
        }
    }

    @Override
    public HttpResponseMessage duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duplicating the response message: " + this), (Object[])new Object[0]);
        }
        HttpResponseMessageImpl msg = null;
        HttpObjectFactory factory = this.getObjectFactory();
        msg = null == factory ? new HttpResponseMessageImpl() : factory.getResponse();
        msg.setIncoming(this.isIncoming());
        msg.setStatusCode(this.myStatusCode);
        msg.setReasonPhrase(this.myReasonBytes);
        super.duplicate(msg);
        return msg;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("De-serializing into: " + this), (Object[])new Object[0]);
        }
        super.readExternal(input);
        if (-1091633150 == this.getDeserializationVersion()) {
            this.setStatusCode(input.readShort());
        } else {
            this.setStatusCode(input.readInt());
        }
        this.setReasonPhrase(this.readByteArray(input));
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Serializing: " + this), (Object[])new Object[0]);
        }
        super.writeExternal(output);
        output.writeShort(this.getStatusCodeAsInt());
        this.writeByteArray(output, this.myReasonBytes);
    }
}

