/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.EncodingUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.transport.http.encoding"}, property={"service.vendor=IBM"})
public class EncodingUtilsImpl
implements EncodingUtils {
    private static final TraceComponent tc = Tr.register(EncodingUtilsImpl.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final byte[] TEST_CHAR = new byte[]{97};
    private final Map<String, String> localeMap = new HashMap<String, String>();
    private final Map<String, String> converterMap = new HashMap<String, String>();
    private final Map<String, Boolean> supportedEncodingsCache = new HashMap<String, Boolean>();
    private final Map<String, List<Locale>> localesCache = new HashMap<String, List<Locale>>();
    private Locale cachedLocale = null;
    private String cachedEncoding = null;
    static final long serialVersionUID = -1198395850126550961L;

    @Activate
    protected void activate(Map<String, Object> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.modified(config);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[]{"reason=" + reason});
        }
        this.cachedEncoding = null;
        this.cachedLocale = null;
        this.localeMap.clear();
        this.converterMap.clear();
        this.supportedEncodingsCache.clear();
        this.localesCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Modified
    protected void modified(Map<String, Object> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Config modified: " + this), (Object[])new Object[0]);
        }
        if (null == config) {
            return;
        }
        String ENC = "encoding.";
        String CONV = "converter.";
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String key = entry.getKey();
            int len = key.length();
            try {
                String value;
                if (len > "encoding.".length() && key.startsWith("encoding.")) {
                    value = (String)entry.getValue();
                    this.localeMap.put(key.substring("encoding.".length()), value);
                    continue;
                }
                if (len <= "converter.".length() || !key.startsWith("converter.")) continue;
                value = (String)entry.getValue();
                this.converterMap.put(key.substring("converter.".length()).toLowerCase(), value.toLowerCase());
            }
            catch (Throwable value) {
                void t;
                FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.http.internal.EncodingUtilsImpl", (String)"128", (Object)this, (Object[])new Object[]{config});
                FFDCFilter.processException((Throwable)t, (String)"EncodingUtils.processConfig", (String)"1", (Object[])new Object[]{key, entry.getValue()});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Invalid property: [" + key + "]=[" + config.get(key) + "]"), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    @Override
    public String getCharsetFromContentType(String type) {
        int index;
        if (null != type && -1 != (index = type.indexOf(59)) && -1 != (index = type.indexOf("charset=", index + 1))) {
            String charset = type.substring(index + 8).trim();
            int end = charset.length() - 1;
            if (-1 == end) {
                return null;
            }
            if (end > 0 && '\"' == charset.charAt(0) && '\"' == charset.charAt(end)) {
                charset = charset.substring(1, end);
            }
            return charset;
        }
        return null;
    }

    @Override
    public List<Locale> getLocales(String acceptLangHdr) {
        if (null == acceptLangHdr) {
            ArrayList<Locale> def = new ArrayList<Locale>(1);
            def.add(Locale.getDefault());
            return def;
        }
        List<Locale> langList = this.localesCache.get(acceptLangHdr);
        if (null == langList) {
            List<List<String>> rc = this.processAcceptLanguage(acceptLangHdr);
            if (null != rc) {
                langList = this.extractLocales(rc);
                this.localesCache.put(acceptLangHdr, langList);
            } else {
                ArrayList<Locale> def = new ArrayList<Locale>(1);
                def.add(Locale.getDefault());
                return def;
            }
        }
        return langList;
    }

    /*
     * WARNING - void declaration
     */
    private List<List<String>> processAcceptLanguage(String acceptLanguage) {
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        TreeMap map = new TreeMap(Collections.reverseOrder());
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            if (language.length() == 0) continue;
            int semicolonIndex = language.indexOf(59);
            Double qValue = 1.0;
            if (semicolonIndex > -1) {
                int qIndex = language.indexOf("q=");
                String qValueStr = language.substring(qIndex + 2);
                try {
                    qValue = Double.valueOf(qValueStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    void nfe;
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.http.internal.EncodingUtilsImpl", (String)"233", (Object)this, (Object[])new Object[]{acceptLanguage});
                    FFDCFilter.processException((Throwable)nfe, (String)"EncodingUtils.processAcceptLanguage", (String)"215");
                }
                language = language.substring(0, semicolonIndex);
            }
            if (language.length() <= 0 || !(qValue > 0.0) || language.charAt(0) == '*') continue;
            ArrayList<String> list = (ArrayList<String>)map.get(qValue);
            if (null == list) {
                list = new ArrayList<String>(1);
            }
            list.add(language);
            map.put(qValue, list);
        }
        ArrayList rc = null;
        if (!map.isEmpty()) {
            rc = new ArrayList(map.values());
        }
        return rc;
    }

    private List<Locale> extractLocales(List<List<String>> allLangs) {
        ArrayList<Locale> rc = new ArrayList<Locale>();
        for (List<String> langList : allLangs) {
            for (String language : langList) {
                String country = "";
                String variant = "";
                int countryIndex = language.indexOf(45);
                if (countryIndex > -1) {
                    int variantIndex = language.indexOf(45, countryIndex + 1);
                    if (variantIndex > -1) {
                        variant = language.substring(variantIndex + 1).trim();
                        country = language.substring(countryIndex, variantIndex).trim();
                    } else {
                        country = language.substring(countryIndex + 1).trim();
                    }
                    language = language.substring(0, countryIndex).trim();
                }
                rc.add(new Locale(language, country, variant));
            }
        }
        return rc;
    }

    @Override
    public String getEncodingFromLocale(Locale locale) {
        String lang;
        if (null == locale) {
            return null;
        }
        if (locale.equals(this.cachedLocale)) {
            return this.cachedEncoding;
        }
        String encoding = this.localeMap.get(locale.toString());
        if (null == encoding && null == (encoding = this.localeMap.get((lang = locale.getLanguage()) + '_' + locale.getCountry()))) {
            encoding = this.localeMap.get(lang);
        }
        this.cachedEncoding = encoding;
        this.cachedLocale = locale;
        return encoding;
    }

    @Override
    public String getJvmConverter(String encoding) {
        String converter;
        if (null != encoding && null != (converter = this.converterMap.get(encoding.toLowerCase()))) {
            return converter;
        }
        return encoding;
    }

    @Override
    public boolean isCharsetSupported(String charset) {
        if (null == charset) {
            return false;
        }
        Boolean supported = this.supportedEncodingsCache.get(charset);
        if (supported != null) {
            return supported;
        }
        try {
            new String(TEST_CHAR, charset);
            supported = Boolean.TRUE;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.http.internal.EncodingUtilsImpl", (String)"345", (Object)this, (Object[])new Object[]{charset});
            supported = Boolean.FALSE;
        }
        this.supportedEncodingsCache.put(charset, supported);
        return supported;
    }

    @Override
    public String stripQuotes(String value) {
        int end;
        if (null == value) {
            return null;
        }
        String modvalue = value.trim();
        if (0 == modvalue.length()) {
            return modvalue;
        }
        boolean needTrimming = false;
        int start = 0;
        if ('\"' == modvalue.charAt(0) || '\'' == modvalue.charAt(0)) {
            start = 1;
            needTrimming = true;
        }
        if ('\"' == modvalue.charAt(end = modvalue.length() - 1) || '\'' == modvalue.charAt(end)) {
            needTrimming = true;
        } else {
            ++end;
        }
        if (needTrimming) {
            return modvalue.substring(start, end);
        }
        return modvalue;
    }
}

