/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.DefaultCommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.ExecutionContextImpl;
import com.ibm.ws.product.utility.extension.DisplayLicenseAgreementTask;
import com.ibm.ws.product.utility.extension.DisplayLicenseInfoTask;
import com.ibm.ws.product.utility.extension.FeatureInfoCommandTask;
import com.ibm.ws.product.utility.extension.HelpCommandTask;
import com.ibm.ws.product.utility.extension.IFixCompareCommandTask;
import com.ibm.ws.product.utility.extension.ValidateCommandTask;
import com.ibm.ws.product.utility.extension.VersionCommandTask;
import java.io.File;

public class ProductUtility {
    private static final CommandTaskRegistry COMMAND_TASK_REGISTRY = new CommandTaskRegistry();
    public static final String SCRIPT_NAME = "productInfo";
    private final CommandConsole console = new DefaultCommandConsole(System.console(), System.out, System.err);
    private final File wlpInstallationFolder = Utils.getInstallDir();

    private static boolean looksLikeHelp(String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return "help".equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }

    public void execute(String[] args) {
        CommandTask commandTask;
        if (args.length == 0) {
            this.printHelpUsageMessage(false);
            return;
        }
        String taskName = args[0].toLowerCase();
        if (ProductUtility.looksLikeHelp(taskName)) {
            taskName = "help";
        }
        if ((commandTask = COMMAND_TASK_REGISTRY.getCommandTask(taskName)) == null) {
            this.printBadCmdMessage(args[0]);
            this.printHelpUsageMessage(true);
            return;
        }
        String[] commandArguments = new String[args.length - 1];
        if (commandArguments.length > 0) {
            System.arraycopy(args, 1, commandArguments, 0, commandArguments.length);
        }
        ExecutionContext executionContext = this.createExecutionContext(commandArguments);
        commandTask.execute(executionContext);
    }

    private void printHelpUsageMessage(boolean error) {
        HelpCommandTask helpCommandTask = (HelpCommandTask)COMMAND_TASK_REGISTRY.getCommandTask("help");
        helpCommandTask.doScriptUsage(this.createExecutionContext(new String[0]), error);
    }

    private void printBadCmdMessage(String arg) {
        HelpCommandTask helpCommandTask = (HelpCommandTask)COMMAND_TASK_REGISTRY.getCommandTask("help");
        helpCommandTask.doExecute(this.createExecutionContext(new String[]{arg}));
    }

    private ExecutionContext createExecutionContext(String[] arguments) {
        ExecutionContextImpl executionContext = new ExecutionContextImpl(this.console, arguments, COMMAND_TASK_REGISTRY);
        executionContext.setAttribute("SCRIPT_NAME", SCRIPT_NAME);
        executionContext.setAttribute("WLP_INSTALLATION_LOCATION", this.wlpInstallationFolder);
        return executionContext;
    }

    public static void main(String[] args) {
        ProductUtility productUtility = new ProductUtility();
        productUtility.execute(args);
    }

    static {
        COMMAND_TASK_REGISTRY.registerCommandTask("help", HelpCommandTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("version", VersionCommandTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("featureInfo", FeatureInfoCommandTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("compare", IFixCompareCommandTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("validate", ValidateCommandTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("viewLicenseAgreement", DisplayLicenseAgreementTask.class);
        COMMAND_TASK_REGISTRY.registerCommandTask("viewLicenseInfo", DisplayLicenseInfoTask.class);
    }
}

