/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.http.BraveHttpHeaders;
import io.opentracing.NoopSpanBuilder;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.impl.AbstractTracer;
import io.opentracing.impl.BraveSpan;
import io.opentracing.impl.BraveSpanBuilder;
import io.opentracing.propagation.Format;
import java.util.HashMap;
import java.util.Map;

public final class BraveTracer
extends AbstractTracer {
    final Brave brave;

    public BraveTracer() {
        this(new Brave.Builder());
    }

    public BraveTracer(Brave.Builder builder) {
        this.brave = builder.build();
    }

    BraveSpanBuilder createSpanBuilder(String operationName) {
        return BraveSpanBuilder.create(this.brave, operationName);
    }

    Map<String, Object> getTraceState(SpanContext spanContext) {
        final Span span = (Span)spanContext;
        return new HashMap<String, Object>(){
            {
                SpanId spanId = ((BraveSpan)span).spanId;
                this.put(BraveHttpHeaders.Sampled.getName(), "1");
                this.put(BraveHttpHeaders.TraceId.getName(), IdConversion.convertToString((long)spanId.getTraceId()));
                this.put(BraveHttpHeaders.SpanId.getName(), IdConversion.convertToString((long)spanId.getSpanId()));
                if (null != spanId.getParentSpanId()) {
                    this.put(BraveHttpHeaders.ParentSpanId.getName(), IdConversion.convertToString((long)spanId.getParentSpanId()));
                }
            }
        };
    }

    Map<String, String> getBaggage(Span span) {
        return ((BraveSpan)span).getBaggage();
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.brave.clientTracer().startNewSpan(((BraveSpan)spanContext).getOperationName());
        this.brave.clientTracer().setClientSent();
        super.inject(spanContext, format, carrier);
        ((BraveSpan)spanContext).setClientTracer(this.brave.clientTracer());
    }

    public <C> Tracer.SpanBuilder extract(Format<C> format, C carrier) {
        BraveSpanBuilder builder = (BraveSpanBuilder)super.extract(format, carrier);
        if (null != builder.traceId && null != builder.parentSpanId) {
            this.brave.serverTracer().setStateCurrentTrace(builder.traceId.longValue(), builder.parentSpanId.longValue(), null, builder.operationName);
            this.brave.serverTracer().setServerReceived();
            builder.withServerTracer(this.brave.serverTracer());
            return builder;
        }
        return NoopSpanBuilder.INSTANCE;
    }
}

