/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.impl.AbstractSpanBuilder;
import io.opentracing.impl.TextMapExtractorImpl;
import io.opentracing.impl.TextMapInjectorImpl;
import io.opentracing.propagation.Extractor;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.Injector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractTracer
implements Tracer {
    static final boolean BAGGAGE_ENABLED = !Boolean.getBoolean("opentracing.propagation.dropBaggage");
    private final PropagationRegistry registry = new PropagationRegistry();

    protected AbstractTracer() {
        this.registry.register(Format.Builtin.TEXT_MAP, new TextMapInjectorImpl(this));
        this.registry.register(Format.Builtin.TEXT_MAP, new TextMapExtractorImpl(this));
    }

    abstract AbstractSpanBuilder createSpanBuilder(String var1);

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return this.createSpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.registry.getInjector(format).inject(spanContext, carrier);
    }

    public <C> Tracer.SpanBuilder extract(Format<C> format, C carrier) {
        return this.registry.getExtractor(format).extract(carrier);
    }

    public <C> Injector<C> register(Format<C> format, Injector<C> injector) {
        return this.registry.register(format, injector);
    }

    public <C> Extractor<C> register(Format<C> format, Extractor<C> extractor) {
        return this.registry.register(format, extractor);
    }

    abstract Map<String, Object> getTraceState(SpanContext var1);

    private static class PropagationRegistry {
        private final ConcurrentMap<Format, Injector> injectors = new ConcurrentHashMap<Format, Injector>();
        private final ConcurrentMap<Format, Extractor> extractors = new ConcurrentHashMap<Format, Extractor>();

        private PropagationRegistry() {
        }

        public <C> Injector<C> getInjector(Format<C> format) {
            if (this.injectors.containsKey(format)) {
                return (Injector)this.injectors.get(format);
            }
            throw new AssertionError((Object)("no registered injector for " + format));
        }

        public <C> Extractor<C> getExtractor(Format<C> format) {
            if (this.extractors.containsKey(format)) {
                return (Extractor)this.extractors.get(format);
            }
            throw new AssertionError((Object)("no registered extractor for " + format));
        }

        public <C> Injector<C> register(Format<C> format, Injector<C> injector) {
            return this.injectors.put(format, injector);
        }

        public <C> Extractor<C> register(Format<C> format, Extractor<C> extractor) {
            return this.extractors.put(format, extractor);
        }
    }
}

