/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.propagation.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MockTracer
implements Tracer {
    private List<MockSpan> finishedSpans = new ArrayList<MockSpan>();
    private final Propagator propagator;

    public MockTracer() {
        this(Propagator.PRINTER);
    }

    public MockTracer(Propagator propagator) {
        this.propagator = propagator;
    }

    public synchronized void reset() {
        this.finishedSpans.clear();
    }

    public synchronized List<MockSpan> finishedSpans() {
        return new ArrayList<MockSpan>(this.finishedSpans);
    }

    protected void onSpanFinished(MockSpan mockSpan) {
    }

    public SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.propagator.inject((MockSpan.MockContext)spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.propagator.extract(format, carrier);
    }

    synchronized void appendFinishedSpan(MockSpan mockSpan) {
        this.finishedSpans.add(mockSpan);
        this.onSpanFinished(mockSpan);
    }

    final class SpanBuilder
    implements Tracer.SpanBuilder {
        private final String operationName;
        private long startMicros;
        private MockSpan.MockContext firstParent;
        private Map<String, Object> initialTags = new HashMap<String, Object>();

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public Tracer.SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public Tracer.SpanBuilder asChildOf(Span parent) {
            return this.addReference("child_of", parent.context());
        }

        public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (this.firstParent == null && (referenceType.equals("child_of") || referenceType.equals("follows_from"))) {
                this.firstParent = (MockSpan.MockContext)referencedContext;
            }
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, String value) {
            this.initialTags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, boolean value) {
            this.initialTags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, Number value) {
            this.initialTags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.startMicros = microseconds;
            return this;
        }

        public Span start() {
            return new MockSpan(MockTracer.this, this.operationName, this.startMicros, this.initialTags, this.firstParent);
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            if (this.firstParent == null) {
                return Collections.EMPTY_MAP.entrySet();
            }
            return this.firstParent.baggageItems();
        }
    }

    public static interface Propagator {
        public static final Propagator PRINTER = new Propagator(){

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                System.out.println("inject(" + ctx + ", " + format + ", " + carrier + ")");
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                System.out.println("extract(" + format + ", " + carrier + ")");
                return null;
            }
        };

        public <C> void inject(MockSpan.MockContext var1, Format<C> var2, C var3);

        public <C> MockSpan.MockContext extract(Format<C> var1, C var2);
    }
}

