/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.IntSerializer;
import io.protostuff.ProtobufOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 256;
    public final int allocSize;
    ByteBuffer current;
    List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

    public LinkBuffer() {
        this(256);
    }

    public LinkBuffer(int allocSize) {
        assert (allocSize >= 8);
        this.allocSize = allocSize;
        this.current = ByteBuffer.allocate(allocSize);
    }

    public long size() {
        long size = 0L;
        for (ByteBuffer b : this.buffers) {
            size += (long)b.remaining();
        }
        if (this.current != null) {
            size += (long)this.current.position();
        }
        return size;
    }

    public List<ByteBuffer> getBuffers() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>(this.buffers.size());
        for (ByteBuffer b : this.buffers) {
            copy.add(b.duplicate());
        }
        return Collections.unmodifiableList(copy);
    }

    private void nextBuffer() {
        this.current.flip();
        this.buffers.add(this.current);
        this.current = ByteBuffer.allocate(this.allocSize);
    }

    private void spliceBuffer(ByteBuffer buf) {
        if (this.current.position() == 0) {
            this.buffers.add(buf);
            return;
        }
        this.current.flip();
        this.buffers.add(this.current);
        this.buffers.add(buf);
        this.current = ByteBuffer.allocate(this.allocSize);
    }

    private void ensureCapacity(int needed) {
        if (this.current.remaining() < needed) {
            this.nextBuffer();
        }
    }

    public List<ByteBuffer> finish() {
        this.current.flip();
        this.buffers.add(this.current);
        this.current = null;
        this.buffers = Collections.unmodifiableList(this.buffers);
        return this.getBuffers();
    }

    public LinkBuffer writeByte(byte value) throws IOException {
        this.ensureCapacity(1);
        this.current.put(value);
        return this;
    }

    public LinkBuffer writeInt16(int value) throws IOException {
        this.ensureCapacity(2);
        this.current.putShort((short)value);
        return this;
    }

    public LinkBuffer writeInt16LE(int value) throws IOException {
        this.ensureCapacity(2);
        IntSerializer.writeInt16LE((int)value, (ByteBuffer)this.current);
        return this;
    }

    public LinkBuffer writeInt32(int value) throws IOException {
        this.ensureCapacity(4);
        this.current.putInt(value);
        return this;
    }

    public LinkBuffer writeInt32LE(int value) throws IOException {
        this.ensureCapacity(4);
        IntSerializer.writeInt32LE((int)value, (ByteBuffer)this.current);
        return this;
    }

    public LinkBuffer writeInt64(long value) throws IOException {
        this.ensureCapacity(8);
        this.current.putLong(value);
        return this;
    }

    public LinkBuffer writeInt64LE(long value) throws IOException {
        this.ensureCapacity(8);
        IntSerializer.writeInt64LE((long)value, (ByteBuffer)this.current);
        return this;
    }

    public LinkBuffer writeVarInt32(int value) throws IOException {
        byte[] buf = new byte[5];
        int locPtr = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buf[locPtr++] = (byte)value;
                this.ensureCapacity(locPtr);
                this.current.put(buf, 0, locPtr);
                return this;
            }
            buf[locPtr++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public LinkBuffer writeVarInt32_2(int value) throws IOException {
        int encSize = ProtobufOutput.computeRawVarint32Size(value);
        this.ensureCapacity(encSize);
        byte[] buf = new byte[encSize];
        int locPtr = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buf[locPtr++] = (byte)value;
                this.current.put(buf);
                return this;
            }
            buf[locPtr++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public LinkBuffer writeVarInt64(long value) throws IOException {
        byte[] buf = new byte[10];
        int locPtr = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buf[locPtr++] = (byte)value;
                this.ensureCapacity(locPtr);
                this.current.put(buf, 0, locPtr);
                return this;
            }
            buf[locPtr++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public LinkBuffer writeVarInt64_2(long value) throws IOException {
        int encSize = ProtobufOutput.computeRawVarint64Size(value);
        this.ensureCapacity(encSize);
        byte[] buf = new byte[encSize];
        int locPtr = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buf[locPtr++] = (byte)value;
                this.current.put(buf);
                return this;
            }
            buf[locPtr++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public LinkBuffer writeDouble(double value) throws IOException {
        return this.writeInt64(Double.doubleToRawLongBits(value));
    }

    public LinkBuffer writeFloat(float value) throws IOException {
        return this.writeInt32(Float.floatToRawIntBits(value));
    }

    public LinkBuffer writeByteArray(byte[] value, int offset, int length) throws IOException {
        if (this.current.remaining() >= length) {
            this.current.put(value, offset, length);
        } else {
            ByteBuffer wrapped = ByteBuffer.wrap(value, offset, length);
            this.spliceBuffer(wrapped);
        }
        return this;
    }

    public LinkBuffer writeByteArray(byte[] value) throws IOException {
        return this.writeByteArray(value, 0, value.length);
    }

    public LinkBuffer writeByteBuffer(ByteBuffer buf) {
        ByteBuffer cp = buf.slice();
        if (this.current.remaining() >= cp.remaining()) {
            this.current.put(cp);
        } else {
            this.spliceBuffer(cp);
        }
        return this;
    }
}

