/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.ObjectSchema;
import io.protostuff.runtime.PolymorphicSchema;
import java.io.IOException;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArraySchema
extends PolymorphicSchema {
    static final int ID_ARRAY_LEN = 3;
    static final int ID_ARRAY_DIMENSION = 2;
    static final String STR_ARRAY_LEN = "c";
    static final String STR_ARRAY_DIMENSION = "b";
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            ArraySchema.transferObject(this, pipe, input, output, ArraySchema.this.strategy);
        }
    };

    static String name(int number) {
        switch (number) {
            case 2: {
                return STR_ARRAY_DIMENSION;
            }
            case 3: {
                return STR_ARRAY_LEN;
            }
            case 15: {
                return "o";
            }
            case 17: {
                return "q";
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'o': {
                return 15;
            }
            case 'q': {
                return 17;
            }
        }
        return 0;
    }

    public ArraySchema(IdStrategy strategy) {
        super(strategy);
    }

    @Override
    public Pipe.Schema<Object> getPipeSchema() {
        return this.pipeSchema;
    }

    public String getFieldName(int number) {
        return ArraySchema.name(number);
    }

    public int getFieldNumber(String name) {
        return ArraySchema.number(name);
    }

    public String messageFullName() {
        return Array.class.getName();
    }

    public String messageName() {
        return Array.class.getSimpleName();
    }

    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(ArraySchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    public void writeTo(Output output, Object value) throws IOException {
        ArraySchema.writeObjectTo(output, value, this, this.strategy);
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Class<?> clazz = value.getClass();
        int dimensions = 1;
        Class<?> componentType = clazz.getComponentType();
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        strategy.writeArrayIdTo(output, componentType);
        output.writeUInt32(3, Array.getLength(value), false);
        output.writeUInt32(2, dimensions, false);
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(strategy.ARRAY_SCHEMA, currentSchema);
        }
        strategy.ARRAY_SCHEMA.writeTo(output, value);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        boolean mapped;
        int number = input.readFieldNumber(schema);
        switch (number) {
            case 15: {
                mapped = false;
                break;
            }
            case 17: {
                mapped = true;
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        ObjectSchema.ArrayWrapper mArrayWrapper = ObjectSchema.newArrayWrapper(input, schema, mapped, strategy);
        if (input instanceof GraphInput) {
            ((GraphInput)input).updateLast(mArrayWrapper.array, owner);
        }
        strategy.COLLECTION_SCHEMA.mergeFrom(input, (Object)mArrayWrapper);
        return mArrayWrapper.array;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        int number = input.readFieldNumber(pipeSchema.wrappedSchema);
        switch (number) {
            case 15: {
                ObjectSchema.transferArray(pipe, input, output, number, pipeSchema, false, strategy);
                return;
            }
            case 17: {
                ObjectSchema.transferArray(pipe, input, output, number, pipeSchema, true, strategy);
                return;
            }
        }
        throw new ProtostuffException("Corrupt input.");
    }
}

