/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.OnDemandSunReflectionFactory;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeEnv {
    public static final boolean ENUMS_BY_NAME;
    public static final boolean AUTO_LOAD_POLYMORPHIC_CLASSES;
    public static final boolean ALLOW_NULL_ARRAY_ELEMENT;
    public static final boolean MORPH_NON_FINAL_POJOS;
    public static final boolean MORPH_COLLECTION_INTERFACES;
    public static final boolean MORPH_MAP_INTERFACES;
    public static final boolean COLLECTION_SCHEMA_ON_REPEATED_FIELDS;
    public static final boolean USE_SUN_MISC_UNSAFE;
    public static final boolean ALWAYS_USE_SUN_REFLECTION_FACTORY;
    static final Method newInstanceFromObjectInputStream;
    static final Constructor<Object> OBJECT_CONSTRUCTOR;
    public static final IdStrategy ID_STRATEGY;

    private static Method getMethodNewInstanceFromObjectInputStream() {
        try {
            return ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    static <T> Class<T> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Instantiator<T> newInstantiator(Class<T> clazz) {
        Constructor<T> constructor = RuntimeEnv.getConstructor(clazz);
        if (constructor == null) {
            if (newInstanceFromObjectInputStream == null) {
                throw new RuntimeException("Could not resolve constructor for " + clazz);
            }
            return new Android2Instantiator<T>(clazz);
        }
        return new DefaultInstantiator<T>(constructor);
    }

    private static <T> Constructor<T> getConstructor(Class<T> clazz) {
        if (ALWAYS_USE_SUN_REFLECTION_FACTORY) {
            return OnDemandSunReflectionFactory.getConstructor(clazz, OBJECT_CONSTRUCTOR);
        }
        try {
            return clazz.getDeclaredConstructor(null);
        }
        catch (SecurityException e) {
            return OBJECT_CONSTRUCTOR == null ? null : OnDemandSunReflectionFactory.getConstructor(clazz, OBJECT_CONSTRUCTOR);
        }
        catch (NoSuchMethodException e) {
            return OBJECT_CONSTRUCTOR == null ? null : OnDemandSunReflectionFactory.getConstructor(clazz, OBJECT_CONSTRUCTOR);
        }
    }

    private RuntimeEnv() {
    }

    static {
        Constructor c = null;
        Class<?> reflectionFactoryClass = null;
        try {
            c = Object.class.getConstructor(null);
            reflectionFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("sun.reflect.ReflectionFactory");
        }
        catch (Exception e) {
            // empty catch block
        }
        OBJECT_CONSTRUCTOR = c != null && reflectionFactoryClass != null ? c : null;
        Method method = newInstanceFromObjectInputStream = OBJECT_CONSTRUCTOR == null ? RuntimeEnv.getMethodNewInstanceFromObjectInputStream() : null;
        if (newInstanceFromObjectInputStream != null) {
            newInstanceFromObjectInputStream.setAccessible(true);
        }
        Properties props = OBJECT_CONSTRUCTOR == null ? new Properties() : System.getProperties();
        ENUMS_BY_NAME = Boolean.parseBoolean(props.getProperty("protostuff.runtime.enums_by_name", "false"));
        AUTO_LOAD_POLYMORPHIC_CLASSES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.auto_load_polymorphic_classes", "true"));
        ALLOW_NULL_ARRAY_ELEMENT = Boolean.parseBoolean(props.getProperty("protostuff.runtime.allow_null_array_element", "false"));
        MORPH_NON_FINAL_POJOS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_non_final_pojos", "false"));
        MORPH_COLLECTION_INTERFACES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_collection_interfaces", "false"));
        MORPH_MAP_INTERFACES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_map_interfaces", "false"));
        COLLECTION_SCHEMA_ON_REPEATED_FIELDS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.collection_schema_on_repeated_fields", "false"));
        USE_SUN_MISC_UNSAFE = OBJECT_CONSTRUCTOR != null && Boolean.parseBoolean(props.getProperty("protostuff.runtime.use_sun_misc_unsafe", "true"));
        ALWAYS_USE_SUN_REFLECTION_FACTORY = OBJECT_CONSTRUCTOR != null && Boolean.parseBoolean(props.getProperty("protostuff.runtime.always_use_sun_reflection_factory", "false"));
        String factoryProp = props.getProperty("protostuff.runtime.id_strategy_factory");
        if (factoryProp == null) {
            ID_STRATEGY = new DefaultIdStrategy();
        } else {
            IdStrategy.Factory factory;
            try {
                factory = (IdStrategy.Factory)RuntimeEnv.loadClass(factoryProp).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ID_STRATEGY = factory.create();
            factory.postCreate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Android2Instantiator<T>
    extends Instantiator<T> {
        final Class<T> clazz;

        Android2Instantiator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T newInstance() {
            try {
                return (T)newInstanceFromObjectInputStream.invoke(null, this.clazz, Object.class);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DefaultInstantiator<T>
    extends Instantiator<T> {
        final Constructor<T> constructor;

        DefaultInstantiator(Constructor<T> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        @Override
        public T newInstance() {
            try {
                return this.constructor.newInstance(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Instantiator<T> {
        public abstract T newInstance();
    }
}

