/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.model.Result;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoLogManager;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataCompareUtils {
    public static Result<Boolean> isFieldEquals(Field f0, Field f1) {
        if (f0 == null) {
            return Result.build(f1 == null);
        }
        if (f1 == null) {
            return Result.build(false);
        }
        if (StringUtils.equalsIgnoreCase(f0.getName(), f1.getName()) && f0.getType() == f1.getType()) {
            boolean result;
            if (f0.getValue() == null) {
                return Result.build(f1.getValue() == null);
            }
            if (f1.getValue() == null) {
                return Result.buildWithParams(false, "Field not equals, name {}, new value is null", f0.getName());
            }
            String currentSerializer = AbstractUndoLogManager.getCurrentSerializer();
            if (StringUtils.equals(currentSerializer, "fastjson")) {
                DataCompareUtils.convertType(f0, f1);
            }
            if (result = Objects.deepEquals(f0.getValue(), f1.getValue())) {
                return Result.ok();
            }
            return Result.buildWithParams(false, "Field not equals, name {}, old value {}, new value {}", f0.getName(), f0.getValue(), f1.getValue());
        }
        return Result.buildWithParams(false, "Field not equals, old name {} type {}, new name {} type {}", f0.getName(), f0.getType(), f1.getName(), f1.getType());
    }

    private static void convertType(Field f0, Field f1) {
        int f0Type = f0.getType();
        int f1Type = f1.getType();
        if (f0Type == 93 && f0.getValue().getClass().equals(String.class)) {
            f0.setValue(Timestamp.valueOf(f0.getValue().toString()));
        }
        if (f1Type == 93 && f1.getValue().getClass().equals(String.class)) {
            f1.setValue(Timestamp.valueOf(f1.getValue().toString()));
        }
        if (f0Type == 3 && f0.getValue().getClass().equals(Integer.class)) {
            f0.setValue(new BigDecimal(f0.getValue().toString()));
        }
        if (f1Type == 3 && f1.getValue().getClass().equals(Integer.class)) {
            f1.setValue(new BigDecimal(f1.getValue().toString()));
        }
    }

    public static Result<Boolean> isRecordsEquals(TableRecords beforeImage, TableRecords afterImage) {
        if (beforeImage == null) {
            return Result.build(afterImage == null, null);
        }
        if (afterImage == null) {
            return Result.build(false, null);
        }
        if (beforeImage.getTableName().equalsIgnoreCase(afterImage.getTableName()) && CollectionUtils.isSizeEquals(beforeImage.getRows(), afterImage.getRows())) {
            if (CollectionUtils.isEmpty(beforeImage.getRows())) {
                return Result.ok();
            }
            return DataCompareUtils.compareRows(beforeImage.getTableMeta(), beforeImage.getRows(), afterImage.getRows());
        }
        return Result.build(false, null);
    }

    public static Result<Boolean> isRowsEquals(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        if (!CollectionUtils.isSizeEquals(oldRows, newRows)) {
            return Result.build(false, null);
        }
        return DataCompareUtils.compareRows(tableMetaData, oldRows, newRows);
    }

    private static Result<Boolean> compareRows(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        Map<String, Map<String, Field>> oldRowsMap = DataCompareUtils.rowListToMap(oldRows, tableMetaData.getPkName());
        Map<String, Map<String, Field>> newRowsMap = DataCompareUtils.rowListToMap(newRows, tableMetaData.getPkName());
        for (String rowKey : oldRowsMap.keySet()) {
            Map<String, Field> oldRow = oldRowsMap.get(rowKey);
            Map<String, Field> newRow = newRowsMap.get(rowKey);
            if (newRow == null) {
                return Result.buildWithParams(false, "compare row failed, rowKey {}, reason [newRow is null]", rowKey);
            }
            for (String fieldName : oldRow.keySet()) {
                Field oldField = oldRow.get(fieldName);
                Field newField = newRow.get(fieldName);
                if (newField == null) {
                    return Result.buildWithParams(false, "compare row failed, rowKey {}, fieldName {}, reason [newField is null]", rowKey, fieldName);
                }
                Result<Boolean> oldEqualsNewFieldResult = DataCompareUtils.isFieldEquals(oldField, newField);
                if (oldEqualsNewFieldResult.getResult().booleanValue()) continue;
                return oldEqualsNewFieldResult;
            }
        }
        return Result.ok();
    }

    private static Map<String, Map<String, Field>> rowListToMap(List<Row> rowList, String primaryKey) {
        HashMap<String, Map<String, Field>> rowMap = new HashMap<String, Map<String, Field>>();
        for (Row row : rowList) {
            HashMap<String, Field> colsMap = new HashMap<String, Field>();
            String rowKey = null;
            for (int j = 0; j < row.getFields().size(); ++j) {
                Field field = row.getFields().get(j);
                if (field.getName().equalsIgnoreCase(primaryKey)) {
                    rowKey = String.valueOf(field.getValue());
                }
                colsMap.put(field.getName().trim().toUpperCase(), field);
            }
            rowMap.put(rowKey, colsMap);
        }
        return rowMap;
    }
}

