/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import io.seata.common.exception.NotSupportYetException;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.druid.SupportSqlWhereMethod;

public abstract class BaseRecognizer
implements SQLRecognizer {
    protected String originalSQL;

    public BaseRecognizer(String originalSQL) {
        this.originalSQL = originalSQL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeVisit(SQLExpr where, SQLASTVisitor visitor) {
        if (where instanceof SQLBinaryOpExpr) {
            visitor.visit((SQLBinaryOpExpr)where);
            return;
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
            return;
        } else if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
            return;
        } else if (where instanceof SQLExistsExpr) {
            visitor.visit((SQLExistsExpr)where);
            return;
        } else {
            if (!(where instanceof SQLMethodInvokeExpr)) throw new IllegalArgumentException("unexpected WHERE expr: " + where.getClass().getSimpleName());
            SQLMethodInvokeExpr whereMethod = (SQLMethodInvokeExpr)where;
            if (!SupportSqlWhereMethod.getInstance().checkIsSupport(whereMethod.getMethodName())) throw new IllegalArgumentException("not support where method: " + whereMethod.getMethodName());
            visitor.visit((SQLMethodInvokeExpr)where);
        }
    }

    protected void wrapSQLParsingException(SQLExpr expr) {
        String errorMsg;
        try {
            errorMsg = "Unknown SQLExpr: " + expr.getClass() + " " + expr;
        }
        catch (Exception e) {
            throw new SQLParsingException("Unknown SQLExpr: " + e.getMessage(), e);
        }
        throw new SQLParsingException(errorMsg);
    }

    public void executeLimit(SQLLimit sqlLimit, SQLASTVisitor visitor) {
        visitor.visit(sqlLimit);
    }

    public void executeOrderBy(SQLOrderBy sqlOrderBy, SQLASTVisitor visitor) {
        visitor.visit(sqlOrderBy);
    }

    @Override
    public String getOriginalSQL() {
        return this.originalSQL;
    }

    protected abstract SQLStatement getAst();

    @Override
    public boolean isSqlSyntaxSupports() {
        SQLASTVisitorAdapter visitor = new SQLASTVisitorAdapter(){

            public boolean visit(SQLJoinTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLInSubQueryExpr x) {
                throw new NotSupportYetException("not support the sql syntax with InSubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLSubqueryTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with SubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLReplaceStatement x) {
                throw new NotSupportYetException("not support the sql syntax with ReplaceStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLMergeStatement x) {
                throw new NotSupportYetException("not support the sql syntax with MergeStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLInsertStatement x) {
                if (null != x.getQuery()) {
                    throw new NotSupportYetException("not support the sql syntax insert with query:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
                }
                return true;
            }
        };
        this.getAst().accept((SQLASTVisitor)visitor);
        return true;
    }

    public static class VMarker {
        public String toString() {
            return "?";
        }
    }
}

