/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.config.DbStateMachineConfig;
import io.seata.saga.engine.impl.ProcessCtrlStateMachineEngine;
import io.seata.saga.rm.StateMachineEngineHolder;
import io.seata.spring.boot.autoconfigure.SeataAutoConfiguration;
import io.seata.spring.boot.autoconfigure.properties.SagaAsyncThreadPoolProperties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"seata.enabled", "seata.saga.enabled"})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, SeataAutoConfiguration.class})
public class SeataSagaAutoConfiguration {
    public static final String SAGA_DATA_SOURCE_BEAN_NAME = "seataSagaDataSource";
    public static final String SAGA_ASYNC_THREAD_POOL_EXECUTOR_BEAN_NAME = "seataSagaAsyncThreadPoolExecutor";
    public static final String SAGA_REJECTED_EXECUTION_HANDLER_BEAN_NAME = "seataSagaRejectedExecutionHandler";

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="seata.saga.state-machine")
    public StateMachineConfig dbStateMachineConfig(DataSource dataSource, @Qualifier(value="seataSagaDataSource") @Autowired(required=false) DataSource sagaDataSource, @Qualifier(value="seataSagaAsyncThreadPoolExecutor") @Autowired(required=false) ThreadPoolExecutor threadPoolExecutor, @Value(value="${spring.application.name:}") String applicationId, @Value(value="${seata.tx-service-group:}") String txServiceGroup) {
        DbStateMachineConfig config = new DbStateMachineConfig();
        config.setDataSource(sagaDataSource != null ? sagaDataSource : dataSource);
        config.setApplicationId(applicationId);
        config.setTxServiceGroup(txServiceGroup);
        if (threadPoolExecutor != null) {
            config.setThreadPoolExecutor(threadPoolExecutor);
        }
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public StateMachineEngine stateMachineEngine(StateMachineConfig config) {
        ProcessCtrlStateMachineEngine engine = new ProcessCtrlStateMachineEngine();
        engine.setStateMachineConfig(config);
        new StateMachineEngineHolder().setStateMachineEngine((StateMachineEngine)engine);
        return engine;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"seata.saga.state-machine.enable-async"}, havingValue="true")
    static class SagaAsyncThreadPoolExecutorConfiguration {
        SagaAsyncThreadPoolExecutorConfiguration() {
        }

        @Bean(value={"seataSagaRejectedExecutionHandler"})
        @ConditionalOnMissingBean
        public RejectedExecutionHandler sagaRejectedExecutionHandler() {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }

        @Bean(value={"seataSagaAsyncThreadPoolExecutor"})
        @ConditionalOnMissingBean
        public ThreadPoolExecutor sagaAsyncThreadPoolExecutor(SagaAsyncThreadPoolProperties properties, @Qualifier(value="seataSagaRejectedExecutionHandler") RejectedExecutionHandler rejectedExecutionHandler) {
            ThreadPoolExecutorFactoryBean threadFactory = new ThreadPoolExecutorFactoryBean();
            threadFactory.setBeanName("sagaStateMachineThreadPoolExecutorFactory");
            threadFactory.setThreadNamePrefix("sagaAsyncExecute-");
            threadFactory.setCorePoolSize(properties.getCorePoolSize());
            threadFactory.setMaxPoolSize(properties.getMaxPoolSize());
            threadFactory.setKeepAliveSeconds(properties.getKeepAliveTime());
            return new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaxPoolSize(), properties.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory, rejectedExecutionHandler);
        }
    }
}

