/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.constant;

import com.google.common.base.Joiner;
import io.shardingjdbc.core.constant.ShardingPropertiesConstant;
import io.shardingjdbc.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public final class ShardingProperties {
    private final Properties props;

    public ShardingProperties(Properties props) {
        this.props = props;
        this.validate();
    }

    private void validate() {
        Set<String> propertyNames = this.props.stringPropertyNames();
        ArrayList<String> errorMessages = new ArrayList<String>(propertyNames.size());
        for (String each : propertyNames) {
            ShardingPropertiesConstant shardingPropertiesConstant = ShardingPropertiesConstant.findByKey(each);
            if (null == shardingPropertiesConstant) continue;
            Class<?> type = shardingPropertiesConstant.getType();
            String value = this.props.getProperty(each);
            if (type == Boolean.TYPE && !StringUtil.isBooleanValue(value)) {
                errorMessages.add(this.getErrorMessage(shardingPropertiesConstant, value));
                continue;
            }
            if (type == Integer.TYPE && !StringUtil.isIntValue(value)) {
                errorMessages.add(this.getErrorMessage(shardingPropertiesConstant, value));
                continue;
            }
            if (type != Long.TYPE || StringUtil.isLongValue(value)) continue;
            errorMessages.add(this.getErrorMessage(shardingPropertiesConstant, value));
        }
        if (!errorMessages.isEmpty()) {
            throw new IllegalArgumentException(Joiner.on((String)" ").join(errorMessages));
        }
    }

    private String getErrorMessage(ShardingPropertiesConstant shardingPropertiesConstant, String invalidValue) {
        return String.format("Value '%s' of '%s' cannot convert to type '%s'.", invalidValue, shardingPropertiesConstant.getKey(), shardingPropertiesConstant.getType().getName());
    }

    public <T> T getValue(ShardingPropertiesConstant shardingPropertiesConstant) {
        String result = this.props.getProperty(shardingPropertiesConstant.getKey(), shardingPropertiesConstant.getDefaultValue());
        if (Boolean.TYPE == shardingPropertiesConstant.getType()) {
            return (T)Boolean.valueOf(result);
        }
        if (Integer.TYPE == shardingPropertiesConstant.getType()) {
            return (T)Integer.valueOf(result);
        }
        if (Long.TYPE == shardingPropertiesConstant.getType()) {
            return (T)Long.valueOf(result);
        }
        return (T)result;
    }
}

