/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.constant.OrderType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.ExpressionClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.expression.SQLExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.util.SQLUtil;

public class GroupByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final ExpressionClauseParser expressionClauseParser;

    public GroupByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.GROUP)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.BY);
        while (true) {
            this.addGroupByItem(this.expressionClauseParser.parse(selectStatement), selectStatement);
            if (!this.lexerEngine.equalAny(Symbol.COMMA)) break;
            this.lexerEngine.nextToken();
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordAfterGroupBy());
        selectStatement.setGroupByLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
    }

    private void addGroupByItem(SQLExpression sqlExpression, SelectStatement selectStatement) {
        OrderItem orderItem;
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordBeforeGroupByItem());
        OrderType orderByType = OrderType.ASC;
        if (this.lexerEngine.equalAny(DefaultKeyword.ASC)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, OrderType.ASC, selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner() + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName()))));
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            SQLIdentifierExpression sqlIdentifierExpression = (SQLIdentifierExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName()), orderByType, OrderType.ASC, selectStatement.getAlias(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName())));
        } else if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            orderItem = new OrderItem(sqlIgnoreExpression.getExpression(), orderByType, OrderType.ASC, selectStatement.getAlias(sqlIgnoreExpression.getExpression()));
        } else {
            return;
        }
        selectStatement.getGroupByItems().add(orderItem);
    }

    protected Keyword[] getUnsupportedKeywordBeforeGroupByItem() {
        return new Keyword[0];
    }

    protected Keyword[] getSkippedKeywordAfterGroupBy() {
        return new Keyword[0];
    }
}

