/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.router;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.parsing.SQLParsingEngine;
import io.shardingjdbc.core.parsing.parser.context.GeneratedKey;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.rewrite.SQLBuilder;
import io.shardingjdbc.core.rewrite.SQLRewriteEngine;
import io.shardingjdbc.core.routing.SQLExecutionUnit;
import io.shardingjdbc.core.routing.SQLRouteResult;
import io.shardingjdbc.core.routing.router.SQLRouter;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.routing.type.all.DatabaseAllRoutingEngine;
import io.shardingjdbc.core.routing.type.complex.CartesianDataSource;
import io.shardingjdbc.core.routing.type.complex.CartesianRoutingResult;
import io.shardingjdbc.core.routing.type.complex.CartesianTableReference;
import io.shardingjdbc.core.routing.type.complex.ComplexRoutingEngine;
import io.shardingjdbc.core.routing.type.simple.SimpleRoutingEngine;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ParsingSQLRouter
implements SQLRouter {
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;
    private final boolean showSQL;
    private final List<Number> generatedKeys;

    public ParsingSQLRouter(ShardingContext shardingContext) {
        this.shardingRule = shardingContext.getShardingRule();
        this.databaseType = shardingContext.getDatabaseType();
        this.showSQL = shardingContext.isShowSQL();
        this.generatedKeys = new LinkedList<Number>();
    }

    @Override
    public SQLStatement parse(String logicSQL, int parametersSize) {
        SQLParsingEngine parsingEngine = new SQLParsingEngine(this.databaseType, logicSQL, this.shardingRule);
        SQLStatement result = parsingEngine.parse();
        if (result instanceof InsertStatement) {
            ((InsertStatement)result).appendGenerateKeyToken(this.shardingRule, parametersSize);
        }
        return result;
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        if (sqlStatement instanceof InsertStatement && null != ((InsertStatement)sqlStatement).getGeneratedKey()) {
            this.processGeneratedKey(parameters, (InsertStatement)sqlStatement, result);
        }
        RoutingResult routingResult = this.route(parameters, sqlStatement);
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, logicSQL, this.databaseType, sqlStatement);
        boolean isSingleRouting = routingResult.isSingleRouting();
        if (sqlStatement instanceof SelectStatement && null != ((SelectStatement)sqlStatement).getLimit()) {
            this.processLimit(parameters, (SelectStatement)sqlStatement, isSingleRouting);
        }
        SQLBuilder sqlBuilder = rewriteEngine.rewrite(!isSingleRouting);
        if (routingResult instanceof CartesianRoutingResult) {
            for (CartesianDataSource cartesianDataSource : ((CartesianRoutingResult)routingResult).getRoutingDataSources()) {
                for (CartesianTableReference cartesianTableReference : cartesianDataSource.getRoutingTableReferences()) {
                    result.getExecutionUnits().add(new SQLExecutionUnit(cartesianDataSource.getDataSource(), rewriteEngine.generateSQL(cartesianTableReference, sqlBuilder)));
                }
            }
        } else {
            for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
                result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, sqlBuilder)));
            }
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getExecutionUnits(), parameters);
        }
        return result;
    }

    private RoutingResult route(List<Object> parameters, SQLStatement sqlStatement) {
        Collection<String> tableNames = sqlStatement.getTables().getTableNames();
        RoutingEngine routingEngine = tableNames.isEmpty() ? new DatabaseAllRoutingEngine(this.shardingRule.getDataSourceMap()) : (1 == tableNames.size() || this.shardingRule.isAllBindingTables(tableNames) || this.shardingRule.isAllInDefaultDataSource(tableNames) ? new SimpleRoutingEngine(this.shardingRule, parameters, tableNames.iterator().next(), sqlStatement) : new ComplexRoutingEngine(this.shardingRule, parameters, tableNames, sqlStatement));
        return routingEngine.route();
    }

    private void processGeneratedKey(List<Object> parameters, InsertStatement insertStatement, SQLRouteResult sqlRouteResult) {
        GeneratedKey generatedKey = insertStatement.getGeneratedKey();
        if (parameters.isEmpty()) {
            sqlRouteResult.getGeneratedKeys().add(generatedKey.getValue());
        } else if (parameters.size() == generatedKey.getIndex()) {
            Number key = this.shardingRule.generateKey(insertStatement.getTables().getSingleTableName());
            parameters.add(key);
            this.setGeneratedKeys(sqlRouteResult, key);
        } else if (-1 != generatedKey.getIndex()) {
            this.setGeneratedKeys(sqlRouteResult, (Number)parameters.get(generatedKey.getIndex()));
        }
    }

    private void setGeneratedKeys(SQLRouteResult sqlRouteResult, Number generatedKey) {
        this.generatedKeys.add(generatedKey);
        sqlRouteResult.getGeneratedKeys().clear();
        sqlRouteResult.getGeneratedKeys().addAll(this.generatedKeys);
    }

    private void processLimit(List<Object> parameters, SelectStatement selectStatement, boolean isSingleRouting) {
        if (isSingleRouting) {
            selectStatement.setLimit(null);
            return;
        }
        boolean isNeedFetchAll = (!selectStatement.getGroupByItems().isEmpty() || !selectStatement.getAggregationSelectItems().isEmpty()) && !selectStatement.isSameGroupByAndOrderByItems();
        selectStatement.getLimit().processParameters(parameters, isNeedFetchAll);
    }
}

