/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;

@Named
@MojoExecutionScoped
public class MavenIncrementalConventions {
    private final MavenProject project;
    private final MojoExecution execution;

    @Inject
    public MavenIncrementalConventions(MavenProject project, MojoExecution execution) {
        this.project = project;
        this.execution = execution;
    }

    public File getExecutionStateLocation() {
        return this.getExecutionStateLocation(this.project, this.execution);
    }

    public File getExecutionStateLocation(MavenProject project, MojoExecution execution) {
        File stateDirectory = this.getProjectStateLocation(project);
        String builderId = this.getExecutionId(execution);
        return new File(stateDirectory, builderId);
    }

    public String getExecutionId(MojoExecution execution) {
        PluginDescriptor pluginDescriptor = execution.getMojoDescriptor().getPluginDescriptor();
        StringBuilder builderId = new StringBuilder();
        builderId.append(pluginDescriptor.getGroupId()).append('_').append(pluginDescriptor.getArtifactId());
        builderId.append('_').append(execution.getGoal()).append('_').append(execution.getExecutionId());
        return builderId.toString();
    }

    public File getProjectStateLocation(MavenProject project) {
        return new File(project.getBuild().getDirectory(), "incremental");
    }
}

