/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Chain several auth providers as if they were one. This is useful for cases where one want to authenticate across
 * several providers, for example, database and fallback to passwd file.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.ChainAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.ChainAuth.class)
public class ChainAuth extends AuthProvider {

  public static final io.vertx.lang.rxjava.TypeArg<ChainAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new ChainAuth((io.vertx.ext.auth.ChainAuth) obj),
    ChainAuth::getDelegate
  );

  private final io.vertx.ext.auth.ChainAuth delegate;
  
  public ChainAuth(io.vertx.ext.auth.ChainAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.ChainAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a Chainable Auth Provider auth provider
   * @return the auth provider
   */
  public static ChainAuth create() { 
    ChainAuth ret = ChainAuth.newInstance(io.vertx.ext.auth.ChainAuth.create());
    return ret;
  }

  /**
   * Appends a auth provider to the chain.
   * @param other auth provider
   * @return self
   */
  public ChainAuth append(AuthProvider other) { 
    delegate.append(other.getDelegate());
    return this;
  }

  /**
   * Removes a provider from the chain.
   * @param other provider to remove
   * @return true if provider was removed, false if non existent in the chain.
   */
  public boolean remove(AuthProvider other) { 
    boolean ret = delegate.remove(other.getDelegate());
    return ret;
  }

  /**
   * Clears the chain.
   */
  public void clear() { 
    delegate.clear();
  }


  public static  ChainAuth newInstance(io.vertx.ext.auth.ChainAuth arg) {
    return arg != null ? new ChainAuth(arg) : null;
  }
}
