/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.util.HashMap;

public class PrimitiveTypeInfo
extends TypeInfo {
    static final HashMap<String, PrimitiveTypeInfo> PRIMITIVES = new HashMap();
    final String name;
    final String boxedName;

    private PrimitiveTypeInfo(String name, String boxedName) {
        this.name = name;
        this.boxedName = boxedName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PrimitiveTypeInfo) {
            return this.name.equals(((PrimitiveTypeInfo)obj).name);
        }
        return false;
    }

    public ClassTypeInfo getBoxed() {
        return ClassTypeInfo.PRIMITIVES.get(this.boxedName);
    }

    @Override
    public ClassKind getKind() {
        return ClassKind.PRIMITIVE;
    }

    @Override
    public String format(boolean qualified) {
        return this.name;
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE};
        Class[] boxes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class};
        for (int i = 0; i < primitives.length; ++i) {
            Class primitive = primitives[i];
            String name = primitive.getName();
            PRIMITIVES.put(name, new PrimitiveTypeInfo(primitive.getName(), boxes[i].getName()));
        }
    }
}

