/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.ClusterSettingsParser;
import io.vertx.ext.mongo.impl.config.ConnectionPoolSettingsParser;
import io.vertx.ext.mongo.impl.config.CredentialListParser;
import io.vertx.ext.mongo.impl.config.ReadPreferenceParser;
import io.vertx.ext.mongo.impl.config.SSLSettingsParser;
import io.vertx.ext.mongo.impl.config.ServerSettingsParser;
import io.vertx.ext.mongo.impl.config.SocketSettingsParser;
import io.vertx.ext.mongo.impl.config.WriteConcernParser;
import java.util.List;
import java.util.Objects;
import org.bson.codecs.BooleanCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DoubleCodec;
import org.bson.codecs.IntegerCodec;
import org.bson.codecs.LongCodec;
import org.bson.codecs.StringCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoClientOptionsParser {
    private final MongoClientSettings settings;
    private static final CodecRegistry commonCodecRegistry = CodecRegistries.fromCodecs((Codec[])new Codec[]{new StringCodec(), new IntegerCodec(), new BooleanCodec(), new DoubleCodec(), new LongCodec()});

    public MongoClientOptionsParser(JsonObject config) {
        ReadPreference readPreference;
        Objects.requireNonNull(config);
        MongoClientSettings.Builder options = MongoClientSettings.builder();
        options.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{commonCodecRegistry, CodecRegistries.fromCodecs((Codec[])new Codec[]{new JsonObjectCodec(config)})}));
        String cs = config.getString("connection_string");
        ConnectionString connectionString = cs == null ? null : new ConnectionString(cs);
        ClusterSettings clusterSettings = new ClusterSettingsParser(connectionString, config).settings();
        options.clusterSettings(clusterSettings);
        ConnectionPoolSettings connectionPoolSettings = new ConnectionPoolSettingsParser(connectionString, config).settings();
        options.connectionPoolSettings(connectionPoolSettings);
        List<MongoCredential> credentials = new CredentialListParser(connectionString, config).credentials();
        options.credentialList(credentials);
        SocketSettings socketSettings = new SocketSettingsParser(connectionString, config).settings();
        options.socketSettings(socketSettings);
        JsonObject hbConfig = config.getJsonObject("heartbeat.socket");
        if (hbConfig != null) {
            SocketSettings heartBeatSocketSettings = new SocketSettingsParser(null, hbConfig).settings();
            options.heartbeatSocketSettings(heartBeatSocketSettings);
        }
        ServerSettings serverSettings = new ServerSettingsParser(config).settings();
        options.serverSettings(serverSettings);
        SslSettings sslSettings = new SSLSettingsParser(connectionString, config).settings();
        options.sslSettings(sslSettings);
        WriteConcern writeConcern = new WriteConcernParser(config).writeConcern();
        if (writeConcern != null) {
            options.writeConcern(writeConcern);
        }
        if ((readPreference = new ReadPreferenceParser(config).readPreference()) != null) {
            options.readPreference(readPreference);
        }
        this.settings = options.build();
    }

    public MongoClientSettings settings() {
        return this.settings;
    }
}

