/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.WriteConcern;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class WriteConcernParser {
    private final WriteConcern writeConcern;

    public WriteConcernParser(JsonObject config) {
        Object wc;
        String wcs = config.getString("writeConcern");
        if (wcs != null) {
            wc = WriteConcern.valueOf((String)wcs);
            if (wc == null) {
                throw new IllegalArgumentException("Invalid WriteConcern " + wcs);
            }
        } else {
            Boolean safe = config.getBoolean("safe");
            Object w = config.getValue("w");
            Integer wtimeout = config.getInteger("wtimeoutMS", null);
            Boolean fsync = config.getBoolean("fsync", null);
            Boolean j = config.getBoolean("j", null);
            if (j == null) {
                j = config.getBoolean("journal", null);
            }
            if (w != null || wtimeout != null || fsync != null && fsync.booleanValue() || j != null && j.booleanValue()) {
                if (w == null) {
                    wc = new WriteConcern(1);
                } else if (w instanceof String) {
                    wc = new WriteConcern((String)w);
                } else if (w instanceof Integer) {
                    wc = new WriteConcern(((Integer)w).intValue());
                } else {
                    throw new IllegalArgumentException("Invalid type " + w.getClass() + " for w of WriteConcern");
                }
                if (wtimeout != null) {
                    wc = wc.withWTimeout((long)wtimeout.intValue(), TimeUnit.MILLISECONDS);
                }
                if (j != null) {
                    wc = wc.withJournal(j);
                }
                if (fsync != null) {
                    wc = wc.withFsync(fsync.booleanValue());
                }
            } else {
                wc = safe != null ? (safe != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED) : null;
            }
        }
        this.writeConcern = wc;
    }

    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

