/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.CompletionImpl;
import io.vertx.ext.unit.impl.ExecutionContext;
import io.vertx.ext.unit.impl.Helper;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class TestContextImpl
implements TestContext,
Task<Result> {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final int STATUS_RUNNING = 0;
    private static final int STATUS_ASYNC = 1;
    private static final int STATUS_COMPLETED = 2;
    private final Map<String, Object> attributes;
    private final Handler<TestContext> callback;
    private final Handler<Throwable> unhandledFailureHandler;
    private final Function<Result, Task<Result>> next;
    private final long timeout;
    private int status;
    private Throwable failed;
    private long beginTime;
    private ExecutionContext context;
    private final LinkedList<AsyncImpl> asyncs = new LinkedList();

    public TestContextImpl(Map<String, Object> attributes, Handler<TestContext> callback, Handler<Throwable> unhandledFailureHandler, Task<Result> next, long timeout) {
        this.attributes = attributes;
        this.next = result -> next;
        this.timeout = timeout;
        this.callback = callback;
        this.unhandledFailureHandler = unhandledFailureHandler;
        this.status = 0;
    }

    public TestContextImpl(Map<String, Object> attributes, Handler<TestContext> callback, Handler<Throwable> unhandledFailureHandler, Function<Result, Task<Result>> next, long timeout) {
        this.attributes = attributes;
        this.next = next;
        this.timeout = timeout;
        this.callback = callback;
        this.unhandledFailureHandler = unhandledFailureHandler;
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryEnd() {
        ExecutionContext ctx;
        boolean end = false;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.asyncs.isEmpty() && this.status == 1) {
                this.status = 2;
                end = true;
            }
            ctx = this.context;
            if (end) {
                this.notify();
            }
        }
        if (end) {
            long endTime = System.currentTimeMillis();
            Result result = new Result(this.attributes, this.beginTime, endTime, this.failed);
            ctx.run(this.next.apply(result), result);
        }
    }

    @Override
    public synchronized <T> T get(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public synchronized <T> T put(String key, Object value) {
        if (value != null) {
            return (T)this.attributes.put(key, value);
        }
        return (T)this.attributes.remove(key);
    }

    @Override
    public synchronized <T> T remove(String key) {
        return (T)this.attributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Result prev, ExecutionContext context) {
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            this.context = context;
            if (prev != null) {
                this.failed = prev.failure;
                this.beginTime = prev.beginTime;
            } else {
                this.beginTime = System.currentTimeMillis();
            }
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Object cancel;
        if (this.timeout > 0L) {
            cancel = () -> {
                try {
                    TestContextImpl testContextImpl = this;
                    synchronized (testContextImpl) {
                        if (this.status == 2) {
                            return;
                        }
                        this.wait(this.timeout);
                        if (this.status == 2) {
                            return;
                        }
                    }
                    this.failed(new TimeoutException());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
            Thread timeoutThread = new Thread((Runnable)cancel);
            timeoutThread.setName("vert.x-unit-timeout-thread-" + threadCount.incrementAndGet());
            timeoutThread.start();
        }
        try {
            this.callback.handle((Object)this);
        }
        catch (Throwable t) {
            this.failed(t);
        }
        finally {
            cancel = this;
            synchronized (cancel) {
                this.status = 1;
            }
            this.tryEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Throwable t) {
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            switch (this.status) {
                case 2: {
                    this.releaseAndClearAsyncs();
                    if (this.failed != null || this.unhandledFailureHandler == null) break;
                    this.unhandledFailureHandler.handle((Object)t);
                    break;
                }
                case 0: {
                    if (this.failed != null) break;
                    this.failed = t;
                    this.releaseAndClearAsyncs();
                    break;
                }
                case 1: {
                    if (this.failed != null) break;
                    this.failed = t;
                    this.releaseAndClearAsyncs();
                    this.tryEnd();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAndClearAsyncs() {
        ArrayList<AsyncImpl> copy;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            copy = new ArrayList<AsyncImpl>(this.asyncs);
            this.asyncs.clear();
        }
        for (AsyncImpl a : copy) {
            a.release();
        }
    }

    @Override
    public AsyncImpl async() {
        return this.async(1);
    }

    @Override
    public AsyncImpl async(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Async completion count must be > 0");
        }
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.status != 2) {
                AsyncImpl async = new AsyncImpl(count);
                if (this.failed == null) {
                    this.asyncs.add(async);
                }
                return async;
            }
            throw new IllegalStateException("Test already completed");
        }
    }

    @Override
    public TestContext assertNull(Object expected) {
        return this.assertNull(expected, null);
    }

    @Override
    public TestContext assertNull(Object expected, String message) {
        if (expected != null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null"));
        }
        return this;
    }

    @Override
    public TestContext assertNotNull(Object expected) {
        return this.assertNotNull(expected, null);
    }

    @Override
    public TestContext assertNotNull(Object expected, String message) {
        if (expected == null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected not null"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition, String message) {
        if (!condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected true"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition) {
        return this.assertTrue(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition) {
        return this.assertFalse(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition, String message) {
        if (condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected false"));
        }
        return this;
    }

    @Override
    public void fail() {
        this.fail((String)null);
    }

    @Override
    public void fail(String message) {
        throw this.reportAssertionError(message != null ? message : "Test failed");
    }

    @Override
    public void fail(Throwable cause) {
        this.failed(cause);
        Helper.uncheckedThrow(cause);
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual) {
        return this.assertEquals(expected, actual, null);
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual, String message) {
        if (actual == null) {
            if (expected != null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + expected + " got null"));
            }
        } else {
            if (expected == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null instead of " + actual));
            }
            if (!expected.equals(actual)) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Not equals : " + expected + " != " + actual));
            }
        }
        return this;
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta) {
        return this.assertInRange(expected, actual, delta, null);
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta, String message) {
        if (Double.compare(expected, actual) != 0 && Math.abs(actual - expected) > delta) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + actual + " to belong to [" + (expected - delta) + "," + (expected + delta) + "]"));
        }
        return this;
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second, String message) {
        if (first == null) {
            if (second == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null != null"));
            }
        } else if (first.equals(second)) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected different values " + first + " != " + second));
        }
        return this;
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess() {
        return this.asyncAssertSuccess(result -> {});
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess(Handler<T> resultHandler) {
        AsyncImpl async = this.async();
        return ar -> {
            if (ar.succeeded()) {
                Object result = ar.result();
                try {
                    resultHandler.handle(result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.failed(ar.cause());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure() {
        return this.asyncAssertFailure((Handler<Throwable>)((Handler)cause -> {}));
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure(Handler<Throwable> causeHandler) {
        AsyncImpl async = this.async();
        return ar -> {
            if (ar.failed()) {
                Throwable result = ar.cause();
                try {
                    causeHandler.handle((Object)result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.failed((Throwable)((Object)this.reportAssertionError("Was expecting a failure instead of of success")));
            }
        };
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second) {
        return this.assertNotEquals(first, second, null);
    }

    private AssertionError reportAssertionError(String message) {
        AssertionError err = new AssertionError((Object)message);
        this.failed((Throwable)((Object)err));
        return err;
    }

    private static String formatMessage(String providedMessage, String defaultMessage) {
        return providedMessage == null ? defaultMessage : providedMessage + ". " + defaultMessage;
    }

    class AsyncImpl
    extends CompletionImpl<Void>
    implements Async {
        private final int initialCount;
        private final AtomicInteger current;

        public AsyncImpl(int initialCount) {
            this.initialCount = initialCount;
            this.current = new AtomicInteger(initialCount);
        }

        @Override
        public int count() {
            return this.current.get();
        }

        @Override
        public void countDown() {
            int value = this.current.updateAndGet(v -> v > 0 ? v - 1 : 0);
            if (value == 0) {
                this.completable.complete(null);
                this.internalComplete();
            }
        }

        @Override
        public void complete() {
            int value = this.current.getAndSet(0);
            if (value > 0) {
                this.completable.complete(null);
                this.internalComplete();
            } else if (value < 0) {
                throw new IllegalStateException("The Async complete method has been called more than " + this.initialCount + " times, check your test.");
            }
        }

        private void release() {
            if (TestContextImpl.this.failed != null) {
                this.completable.completeExceptionally(TestContextImpl.this.failed);
            } else {
                this.completable.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void internalComplete() {
            boolean complete;
            TestContextImpl testContextImpl = TestContextImpl.this;
            synchronized (testContextImpl) {
                complete = TestContextImpl.this.asyncs.remove(this);
            }
            if (complete) {
                TestContextImpl.this.tryEnd();
            }
            this.release();
        }
    }
}

