/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.ext.unit.junit.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int times = repeat.value();
            result = new RepeatStatement(times, statement, description);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final int times;
        private final Statement statement;
        private final Description description;

        private RepeatStatement(int times, Statement statement, Description description) {
            this.times = times;
            this.statement = statement;
            this.description = description;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.times; ++i) {
                System.out.println("*** Iteration " + (i + 1) + "/" + this.times + " of test " + this.description.getDisplayName());
                this.statement.evaluate();
            }
        }
    }
}

