/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.auth.htdigest.HtdigestAuth;
import java.util.Set;
import io.vertx.rxjava.ext.web.RoutingContext;

/**
 * An auth handler that provides HTTP Basic Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.DigestAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.web.handler.DigestAuthHandler.class)
public class DigestAuthHandler implements AuthHandler, io.vertx.core.Handler<RoutingContext> {

  public static final io.vertx.lang.rxjava.TypeArg<DigestAuthHandler> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new DigestAuthHandler((io.vertx.ext.web.handler.DigestAuthHandler) obj),
    DigestAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.DigestAuthHandler delegate;
  
  public DigestAuthHandler(io.vertx.ext.web.handler.DigestAuthHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.DigestAuthHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Create a digest auth handler
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static DigestAuthHandler create(HtdigestAuth authProvider) { 
    DigestAuthHandler ret = DigestAuthHandler.newInstance(io.vertx.ext.web.handler.DigestAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a digest auth handler, specifying the expire timeout for nonces.
   * @param authProvider the auth service to use
   * @param nonceExpireTimeout the nonce expire timeout in milliseconds.
   * @return the auth handler
   */
  public static DigestAuthHandler create(HtdigestAuth authProvider, long nonceExpireTimeout) { 
    DigestAuthHandler ret = DigestAuthHandler.newInstance(io.vertx.ext.web.handler.DigestAuthHandler.create(authProvider.getDelegate(), nonceExpireTimeout));
    return ret;
  }


  public static  DigestAuthHandler newInstance(io.vertx.ext.web.handler.DigestAuthHandler arg) {
    return arg != null ? new DigestAuthHandler(arg) : null;
  }
}
