/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AuthHandlerImpl
implements AuthHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthHandlerImpl.class);
    protected final AuthProvider authProvider;
    protected final Set<String> authorities = new HashSet<String>();

    public AuthHandlerImpl(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        this.authorities.add(authority);
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        this.authorities.addAll(authorities);
        return this;
    }

    protected void authorise(User user, RoutingContext context) {
        int requiredcount = this.authorities.size();
        if (requiredcount > 0) {
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean sentFailure = new AtomicBoolean();
            Handler authHandler = res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (count.incrementAndGet() == requiredcount) {
                            context.next();
                        }
                    } else if (sentFailure.compareAndSet(false, true)) {
                        context.fail(403);
                    }
                } else {
                    context.fail(res.cause());
                }
            };
            for (String authority : this.authorities) {
                user.isAuthorised(authority, authHandler);
            }
        } else {
            context.next();
        }
    }
}

