// Generated by delombok at Mon May 20 07:04:19 UTC 2024
package io.weaviate.client;

import java.util.Map;

public class Config {
  private static final int DEFAULT_TIMEOUT_SECONDS = 60;
  private final String scheme;
  private final String host;
  private final String version;
  private final Map<String, String> headers;
  private final int connectionTimeout;
  private final int connectionRequestTimeout;
  private final int socketTimeout;
  private String proxyHost;
  private int proxyPort;
  private String proxyScheme;
  private boolean gRPCSecured;
  private String gRPCHost;

  public Config(String scheme, String host) {
    this(scheme, host, null, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS);
  }

  public Config(String scheme, String host, Map<String, String> headers) {
    this(scheme, host, headers, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS);
  }

  public Config(String scheme, String host, Map<String, String> headers, int connectionTimeout, int connectionRequestTimeout, int socketTimeout) {
    this.scheme = scheme;
    this.host = host;
    this.version = "v1";
    this.headers = headers;
    this.connectionTimeout = connectionTimeout;
    this.connectionRequestTimeout = connectionRequestTimeout;
    this.socketTimeout = socketTimeout;
  }

  public Config(String scheme, String host, Map<String, String> headers, int timeout) {
    this(scheme, host, headers, timeout, false, null);
  }

  public Config(String scheme, String host, Map<String, String> headers, int timeout, boolean gRPCSecured, String gRPCHost) {
    this.scheme = scheme;
    this.host = host;
    this.version = "v1";
    this.headers = headers;
    this.connectionTimeout = timeout;
    this.connectionRequestTimeout = timeout;
    this.socketTimeout = timeout;
    this.gRPCSecured = gRPCSecured;
    this.gRPCHost = gRPCHost;
  }

  public String getBaseURL() {
    return scheme + "://" + host + "/" + version;
  }

  public void setProxy(String proxyHost, int proxyPort, String proxyScheme) {
    this.proxyHost = proxyHost;
    this.proxyPort = proxyPort;
    this.proxyScheme = proxyScheme;
  }

  public boolean useGRPC() {
    return this.gRPCHost != null && !this.gRPCHost.trim().isEmpty();
  }

  @java.lang.SuppressWarnings("all")
  public String getScheme() {
    return this.scheme;
  }

  @java.lang.SuppressWarnings("all")
  public String getHost() {
    return this.host;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, String> getHeaders() {
    return this.headers;
  }

  @java.lang.SuppressWarnings("all")
  public int getConnectionTimeout() {
    return this.connectionTimeout;
  }

  @java.lang.SuppressWarnings("all")
  public int getConnectionRequestTimeout() {
    return this.connectionRequestTimeout;
  }

  @java.lang.SuppressWarnings("all")
  public int getSocketTimeout() {
    return this.socketTimeout;
  }

  @java.lang.SuppressWarnings("all")
  public String getProxyHost() {
    return this.proxyHost;
  }

  @java.lang.SuppressWarnings("all")
  public int getProxyPort() {
    return this.proxyPort;
  }

  @java.lang.SuppressWarnings("all")
  public String getProxyScheme() {
    return this.proxyScheme;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isGRPCSecured() {
    return this.gRPCSecured;
  }

  @java.lang.SuppressWarnings("all")
  public void setGRPCSecured(final boolean gRPCSecured) {
    this.gRPCSecured = gRPCSecured;
  }

  @java.lang.SuppressWarnings("all")
  public String getGRPCHost() {
    return this.gRPCHost;
  }

  @java.lang.SuppressWarnings("all")
  public void setGRPCHost(final String gRPCHost) {
    this.gRPCHost = gRPCHost;
  }
}
