// Generated by delombok at Mon May 20 07:04:19 UTC 2024
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class NearVectorArgument implements Argument {
  private final Float[] vector;
  private final Float certainty;
  private final Float distance;
  private final String[] targetVectors;

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    if (vector != null) {
      arg.add(String.format("vector:%s", Serializer.array(vector)));
    }
    if (certainty != null) {
      arg.add(String.format("certainty:%s", certainty));
    }
    if (distance != null) {
      arg.add(String.format("distance:%s", distance));
    }
    if (ArrayUtils.isNotEmpty(targetVectors)) {
      arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(targetVectors)));
    }
    return String.format("nearVector:{%s}", String.join(" ", arg));
  }

  @java.lang.SuppressWarnings("all")
  NearVectorArgument(final Float[] vector, final Float certainty, final Float distance, final String[] targetVectors) {
    this.vector = vector;
    this.certainty = certainty;
    this.distance = distance;
    this.targetVectors = targetVectors;
  }


  @java.lang.SuppressWarnings("all")
  public static class NearVectorArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private Float[] vector;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Float distance;
    @java.lang.SuppressWarnings("all")
    private String[] targetVectors;

    @java.lang.SuppressWarnings("all")
    NearVectorArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder vector(final Float[] vector) {
      this.vector = vector;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder distance(final Float distance) {
      this.distance = distance;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder targetVectors(final String[] targetVectors) {
      this.targetVectors = targetVectors;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearVectorArgument build() {
      return new NearVectorArgument(this.vector, this.certainty, this.distance, this.targetVectors);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearVectorArgument.NearVectorArgumentBuilder(vector=" + java.util.Arrays.deepToString(this.vector) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + java.util.Arrays.deepToString(this.targetVectors) + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static NearVectorArgument.NearVectorArgumentBuilder builder() {
    return new NearVectorArgument.NearVectorArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public Float[] getVector() {
    return this.vector;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public Float getDistance() {
    return this.distance;
  }

  @java.lang.SuppressWarnings("all")
  public String[] getTargetVectors() {
    return this.targetVectors;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "NearVectorArgument(vector=" + java.util.Arrays.deepToString(this.getVector()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + java.util.Arrays.deepToString(this.getTargetVectors()) + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof NearVectorArgument)) return false;
    final NearVectorArgument other = (NearVectorArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$certainty = this.getCertainty();
    final java.lang.Object other$certainty = other.getCertainty();
    if (this$certainty == null ? other$certainty != null : !this$certainty.equals(other$certainty)) return false;
    final java.lang.Object this$distance = this.getDistance();
    final java.lang.Object other$distance = other.getDistance();
    if (this$distance == null ? other$distance != null : !this$distance.equals(other$distance)) return false;
    if (!java.util.Arrays.deepEquals(this.getVector(), other.getVector())) return false;
    if (!java.util.Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof NearVectorArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $certainty = this.getCertainty();
    result = result * PRIME + ($certainty == null ? 43 : $certainty.hashCode());
    final java.lang.Object $distance = this.getDistance();
    result = result * PRIME + ($distance == null ? 43 : $distance.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getVector());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getTargetVectors());
    return result;
  }
}
